/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.message;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.http.HttpResponse;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.Feedable;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.netty.impl.message.ReactorNettyResponseWrapper;
import org.mule.service.http.netty.impl.message.content.NettyFeedableHttpEntity;
import org.mule.service.http.netty.impl.message.content.OnlyTrailersFeedable;
import org.mule.service.http.netty.impl.message.content.StreamAndFutureFeedable;
import org.mule.service.http.netty.impl.streaming.BlockingBidirectionalStream;
import org.mule.service.http.netty.impl.streaming.CancelableOutputStream;
import org.mule.service.http.netty.impl.util.HttpResponseCreatorUtils;
import reactor.netty.http.client.HttpClientResponse;

public class HttpResponseCreator {
    private static final String HEADER_CONTENT_TYPE = "Content-Type".toLowerCase();
    private static final String HEADER_CONTENT_LENGTH = "Content-Length".toLowerCase();
    public static final byte[] EMPTY_BYTES = new byte[0];

    public org.mule.runtime.http.api.domain.message.response.HttpResponse create(HttpResponse response, InputStream inputStream) {
        HttpResponseBuilder responseBuilder = HttpResponseCreatorUtils.buildResponseHeaders(response);
        String contentType = HttpResponseCreatorUtils.extractHeader(response, HEADER_CONTENT_TYPE);
        String contentLengthAsString = HttpResponseCreatorUtils.extractHeader(response, HEADER_CONTENT_LENGTH);
        long contentLength = HttpResponseCreatorUtils.parseContentLength(contentLengthAsString);
        responseBuilder.entity(HttpResponseCreatorUtils.createEntity(inputStream, contentType, contentLength, response.status().code(), CompletableFuture.completedFuture(MultiMap.emptyMultiMap())));
        return responseBuilder.build();
    }

    public org.mule.runtime.http.api.domain.message.response.HttpResponse create(HttpClientResponse response, ByteBuf byteBuf) {
        byte[] bytes = byteBuf == null ? EMPTY_BYTES : ByteBufUtil.getBytes((ByteBuf)byteBuf);
        ByteArrayInputStream inputStream = byteBuf == null ? null : new ByteArrayInputStream(bytes);
        int statusCode = response.status().code();
        String contentType = HttpResponseCreatorUtils.extractHeader(response, HEADER_CONTENT_TYPE);
        CompletableFuture<MultiMap<String, String>> trailersFuture = HttpResponseCreatorUtils.trailersAsFuture(response);
        HttpEntity entity = HttpResponseCreatorUtils.createEntity(inputStream, contentType, bytes.length, statusCode, trailersFuture);
        return new ReactorNettyResponseWrapper(response, entity, new OnlyTrailersFeedable(trailersFuture));
    }

    public ReactorNettyResponseWrapper createFeedable(HttpClientResponse response) {
        int statusCode = response.status().code();
        String contentType = HttpResponseCreatorUtils.extractHeader(response, HEADER_CONTENT_TYPE);
        String contentLength = HttpResponseCreatorUtils.extractHeader(response, HEADER_CONTENT_LENGTH);
        long contentLengthAsLong = HttpResponseCreatorUtils.parseContentLength(contentLength);
        if (HttpResponseCreatorUtils.isMultipartMixed(contentType)) {
            CompletableFuture<MultiMap<String, String>> futureTrailers = HttpResponseCreatorUtils.trailersAsFuture(response);
            BlockingBidirectionalStream bidirectionalStream = new BlockingBidirectionalStream();
            CancelableOutputStream dataSink = bidirectionalStream.getOutputStream();
            HttpEntity entity = HttpResponseCreatorUtils.createMultipartEntity(bidirectionalStream.getInputStream(), contentLengthAsLong, contentType, futureTrailers);
            return new ReactorNettyResponseWrapper(response, entity, new StreamAndFutureFeedable(dataSink, futureTrailers));
        }
        if (contentLengthAsLong == 0L || HttpResponseCreatorUtils.isEmptyResponseStatus(statusCode)) {
            CompletableFuture<MultiMap<String, String>> futureTrailers = HttpResponseCreatorUtils.trailersAsFuture(response);
            EmptyHttpEntity entity = new EmptyHttpEntity(futureTrailers);
            return new ReactorNettyResponseWrapper(response, (HttpEntity)entity, new OnlyTrailersFeedable(futureTrailers));
        }
        NettyFeedableHttpEntity entity = new NettyFeedableHttpEntity(contentLengthAsLong);
        return new ReactorNettyResponseWrapper(response, (HttpEntity)entity, (Feedable)entity);
    }
}

