/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.transaction;

import java.util.Objects;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.connection.ConnectionHandlerAdapter;
import org.mule.runtime.module.extension.internal.runtime.transaction.ExtensionTransactionalResource;
import org.mule.sdk.api.connectivity.TransactionalConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransactionalConnectionHandler<T extends TransactionalConnection>
implements ConnectionHandlerAdapter<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionalConnectionHandler.class);
    private final ExtensionTransactionalResource<T> resource;
    private final ConnectionHandlerAdapter<T> connectionHandler;

    public TransactionalConnectionHandler(ExtensionTransactionalResource<T> resource) {
        this.resource = Objects.requireNonNull(resource, "resource cannot be null");
        this.connectionHandler = Objects.requireNonNull((ConnectionHandlerAdapter)resource.getConnectionHandler());
    }

    public T getConnection() throws ConnectionException {
        return this.resource.getConnection();
    }

    public void release() {
    }

    public void invalidate() {
        try {
            this.forceRollback();
        }
        catch (Exception e) {
            LOGGER.atWarn().setCause((Throwable)e).setMessage(() -> String.format("Failed to rollback transaction while invalidating connection %s. %s", e, e.getMessage()));
        }
        finally {
            this.connectionHandler.invalidate();
        }
    }

    public void close() throws MuleException {
        try {
            this.forceRollback();
        }
        finally {
            this.connectionHandler.close();
        }
    }

    public ConnectionProvider<T> getConnectionProvider() {
        return this.connectionHandler.getConnectionProvider();
    }

    private void forceRollback() throws TransactionException {
        try {
            TransactionCoordination.getInstance().rollbackCurrentTransaction();
        }
        catch (Exception e) {
            throw new TransactionException((Throwable)e);
        }
    }
}

