/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metrics.exporter.config.impl;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.module.observability.AbstractFileObservabilitySignalConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMeterExporterConfiguration
extends AbstractFileObservabilitySignalConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(FileMeterExporterConfiguration.class);
    private static final String CONFIGURATION_FILE_NAME = "meter-exporter.conf";

    public FileMeterExporterConfiguration(MuleContext muleContext) {
        super(path -> FileMeterExporterConfiguration.findArtifactConfigFile((ClassLoader)muleContext.getExecutionClassLoader(), (String)path), muleContext.getDeploymentProperties(), muleContext.getId());
    }

    protected void onConfigurationFileNotFound() {
        logger.atInfo().log("Metric exporter configuration file named '{}' not found {}. Using default configuration.", (Object)this.getSignalConfigurationFileName(), (Object)this.getConfigurationFileLocations());
    }

    protected void onConfigurationFileLoadError(Exception error, File configurationFile) {
        logger.atWarn().log("Meter exporter configuration file at '{}' had a parsing error: {}. Using default configuration.", (Object)configurationFile.getAbsolutePath(), (Object)error.getMessage());
    }

    protected String getSignalConfigurationFileName() {
        return CONFIGURATION_FILE_NAME;
    }

    protected Path getSignalConfigurationFileDirectoryPath() {
        return Paths.get(System.getProperty("mule.openTelemetry.meter.exporter.configurationFilePath", MuleFoldersUtil.getConfFolder().getAbsolutePath()), new String[0]).toAbsolutePath();
    }

    protected boolean isArtifactLevelProperty(String configurationKey) {
        return false;
    }
}

