/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2FrameStream;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.concurrent.Executor;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.runtime.http.api.sse.server.SseClient;
import org.mule.runtime.http.api.sse.server.SseClientConfig;
import org.mule.service.http.netty.impl.server.ChannelPromises;
import org.mule.service.http.netty.impl.server.DirectResponseSender;
import org.mule.service.http.netty.impl.server.Http2Writer;
import org.mule.service.http.netty.impl.server.HttpWriter;
import org.mule.service.http.netty.impl.server.StreamingResponseSender;
import org.mule.service.http.netty.impl.streaming.ReactiveResponseSender;
import org.mule.service.http.netty.impl.streaming.ResponseStatusCallbackAdapter;

public class NettyHttp2RequestReadyCallback
implements HttpResponseReadyCallback {
    private final ChannelHandlerContext ctx;
    private final Http2FrameStream frameStream;
    private final HttpRequest request;
    private final Executor ioExecutor;
    private final Http2Writer frameWriter;

    public NettyHttp2RequestReadyCallback(ChannelHandlerContext ctx, Http2FrameStream stream, HttpRequest request, Executor ioExecutor) {
        this.ctx = ctx;
        this.frameStream = stream;
        this.request = request;
        this.ioExecutor = ioExecutor;
        this.frameWriter = new Http2Writer(ctx, this.frameStream);
    }

    public void responseReady(HttpResponse response, ResponseStatusCallback responseStatusCallback) {
        try {
            this.sendResponse(this.ctx, response, responseStatusCallback);
        }
        catch (Exception e) {
            responseStatusCallback.onErrorSendingResponse((Throwable)e);
        }
    }

    public Writer startResponse(HttpResponse response, ResponseStatusCallback responseStatusCallback, final Charset encoding) {
        final ResponseStatusCallbackAdapter statusCallback = new ResponseStatusCallbackAdapter(responseStatusCallback);
        this.frameWriter.writeResponseHeader(this.request, response, ChannelPromises.promiseToCallback(this.ctx, statusCallback, false));
        return new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) {
                ByteBuf content = NettyHttp2RequestReadyCallback.this.ctx.alloc().buffer();
                content.writeCharSequence((CharSequence)new String(cbuf, off, len), encoding);
                NettyHttp2RequestReadyCallback.this.frameWriter.writeContent(content, false, ChannelPromises.promiseToCallback(NettyHttp2RequestReadyCallback.this.ctx, statusCallback, false));
            }

            @Override
            public void flush() {
                NettyHttp2RequestReadyCallback.this.ctx.flush();
            }

            @Override
            public void close() {
                NettyHttp2RequestReadyCallback.this.frameWriter.writeContent(Unpooled.EMPTY_BUFFER, true, ChannelPromises.promiseToCallback(NettyHttp2RequestReadyCallback.this.ctx, statusCallback, true));
            }
        };
    }

    public SseClient startSseResponse(SseClientConfig config) {
        throw new UnsupportedOperationException("SSE is not supported over HTTP/2");
    }

    private void sendResponse(ChannelHandlerContext ctx, HttpResponse response, ResponseStatusCallback callback) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity.isReactive()) {
            new ReactiveResponseSender(this.request, ctx, response, callback, (HttpWriter)this.frameWriter).send();
        } else if (entity.isStreaming()) {
            new StreamingResponseSender(this.request, ctx, response, callback, this.ioExecutor, this.frameWriter).send();
        } else {
            new DirectResponseSender(this.request, ctx, response, callback, (HttpWriter)this.frameWriter).send();
        }
    }
}

