/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import java.math.BigInteger;
import org.apfloat.internal.LongModConstants;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class LongElementaryModMath {
    private static final long[] INVERSE_MODULUS = new long[]{BigInteger.ONE.shiftLeft(119).divide(BigInteger.valueOf(LongModConstants.MODULUS[0])).longValueExact(), BigInteger.ONE.shiftLeft(119).divide(BigInteger.valueOf(LongModConstants.MODULUS[1])).longValueExact(), BigInteger.ONE.shiftLeft(119).divide(BigInteger.valueOf(LongModConstants.MODULUS[2])).longValueExact()};
    private long modulus;
    private long inverseModulus;

    public final long modMultiply(long a, long b) {
        long tl = a * b;
        long th = Math.multiplyHigh(a, b) << 9 | tl >>> 55;
        long r1 = tl - Math.multiplyHigh(th, this.inverseModulus) * this.modulus;
        long r2 = r1 - this.modulus;
        return r2 < 0L ? r1 : r2;
    }

    public final long modAdd(long a, long b) {
        long r = a + b;
        return r >= this.modulus ? r - this.modulus : r;
    }

    public final long modSubtract(long a, long b) {
        long r = a - b;
        return r < 0L ? r + this.modulus : r;
    }

    public final long getModulus() {
        return this.modulus;
    }

    public final void setModulus(long modulus) {
        if (modulus == LongModConstants.MODULUS[0]) {
            this.inverseModulus = INVERSE_MODULUS[0];
        } else if (modulus == LongModConstants.MODULUS[1]) {
            this.inverseModulus = INVERSE_MODULUS[1];
        } else if (modulus == LongModConstants.MODULUS[2]) {
            this.inverseModulus = INVERSE_MODULUS[2];
        } else assert (false);
        this.modulus = modulus;
    }
}

