/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Stream;
import org.apfloat.Apcomplex;
import org.apfloat.ApcomplexMath;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatArithmeticException;
import org.apfloat.ApfloatHelper;
import org.apfloat.ApfloatMath;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.Apint;
import org.apfloat.ApintMath;
import org.apfloat.Aprational;
import org.apfloat.InfiniteExpansionException;
import org.apfloat.RoundingHelper;
import org.apfloat.spi.Util;

class HypergeometricHelper {
    private long targetPrecision;
    private long extraPrecision;
    private long workingPrecision;
    private long reducePrecision;
    private int radix;
    private Apcomplex[] a;
    private Apcomplex[] b;
    private Apcomplex z;
    private Apint one;
    private Apint zero;

    private HypergeometricHelper(Apcomplex[] a, Apcomplex[] b, Apcomplex z) {
        this.radix = z.radix();
        this.extraPrecision = ApfloatHelper.getSmallExtraPrecision(this.radix);
        this.workingPrecision = this.targetPrecision = ApfloatHelper.extendPrecision(HypergeometricHelper.precision(a, b, new Apcomplex[]{z}), this.extraPrecision);
        this.reducePrecision = HypergeometricHelper.reducePrecision(z, a);
        this.a = (Apcomplex[])Arrays.stream(a).map(c -> ApfloatHelper.extendPrecision(c, this.extraPrecision)).toArray(Apcomplex[]::new);
        this.b = (Apcomplex[])Arrays.stream(b).map(c -> ApfloatHelper.extendPrecision(c, this.extraPrecision)).toArray(Apcomplex[]::new);
        this.z = this.ensurePrecision(z);
        this.one = Apint.ONES[this.radix];
        this.zero = Apint.ZEROS[this.radix];
    }

    public static Apcomplex hypergeometricPFQ(Apcomplex[] a, Apcomplex[] b, Apcomplex z) {
        HypergeometricHelper helper = new HypergeometricHelper(a, b, z);
        return helper.result(helper.hypergeometricPFQ());
    }

    public static Apcomplex hypergeometricPFQRegularized(Apcomplex[] a, Apcomplex[] b, Apcomplex z) {
        HypergeometricHelper helper = new HypergeometricHelper(a, b, z);
        return helper.result(helper.hypergeometricPFQRegularized());
    }

    private Apcomplex hypergeometricPFQRegularized() {
        Apcomplex result;
        Apfloat n = null;
        int j = -1;
        for (int i = 0; i < this.b.length; ++i) {
            Apfloat br = this.b[i].real().negate();
            if (!ApcomplexMath.isNonPositiveInteger(this.b[i])) continue;
            if (n == null) {
                j = i;
                n = br;
                continue;
            }
            if (br.compareTo(n) <= 0) continue;
            j = i;
            n = br;
        }
        if (n == null) {
            Apcomplex[] gamma = (Apcomplex[])Arrays.stream(this.b).map(this::ensureGammaPrecision).map(ApcomplexMath::gamma).toArray(Apcomplex[]::new);
            result = this.hypergeometricPFQ().divide(ApcomplexMath.product(gamma));
        } else {
            Apfloat n1 = n.add(this.one);
            result = HypergeometricHelper.pochhammerProduct(this.a, n1);
            if (!result.isZero()) {
                Apfloat n2 = ApfloatHelper.limitPrecision(n.add(new Apint(2L, this.radix)), this.workingPrecision);
                Apcomplex[] gamma = (Apcomplex[])Arrays.stream(this.b).map(n1::add).map(this::ensureGammaPrecision).map(ApcomplexMath::gamma).toArray(Apcomplex[]::new);
                result = result.multiply(ApcomplexMath.pow(this.z, n1)).divide(ApcomplexMath.gamma(n2).multiply(ApcomplexMath.product(gamma)));
                this.a = (Apcomplex[])Arrays.stream(this.a).map(n1::add).toArray(Apcomplex[]::new);
                this.b = (Apcomplex[])Arrays.stream(this.b).map(n1::add).toArray(Apcomplex[]::new);
                this.b[j] = n2;
                result = result.multiply(this.hypergeometricPFQ());
            }
        }
        return result;
    }

    private static Apcomplex pochhammerProduct(Apcomplex[] a, Apfloat n) {
        Apcomplex[] pochhammer = (Apcomplex[])Arrays.stream(a).map(e -> ApcomplexMath.pochhammer(e, n)).toArray(Apcomplex[]::new);
        return ApcomplexMath.product(pochhammer);
    }

    public static Apcomplex hypergeometricU(Apcomplex a, Apcomplex b, Apcomplex z, boolean fastOnly) {
        HypergeometricHelper helper = new HypergeometricHelper(new Apcomplex[]{a}, new Apcomplex[]{b}, z);
        return helper.result(helper.hypergeometricU(fastOnly));
    }

    private Apcomplex hypergeometricPFQ() throws ArithmeticException, ApfloatRuntimeException {
        Apcomplex result = this.checkResult();
        if (result != null) {
            return result;
        }
        ArrayList<Apcomplex> bList = new ArrayList<Apcomplex>(Arrays.asList(this.b));
        this.a = (Apcomplex[])Arrays.stream(this.a).filter(z -> !bList.remove(z)).toArray(Apcomplex[]::new);
        this.b = bList.toArray(new Apcomplex[0]);
        if (this.a.length == 2 && this.b.length == 1) {
            return this.hypergeometric2F1(this.a[0], this.a[1], this.b[0], this.z);
        }
        if ((long)this.a.length > (long)this.b.length + 1L) {
            if (this.z.isZero()) {
                return new Apfloat(1L, this.targetPrecision, this.radix);
            }
            throw new ApfloatArithmeticException("Series does not converge", "hypergeometric.nonconvergence", new Object[0]);
        }
        if (this.a.length == 0 && this.b.length == 0) {
            return ApcomplexMath.exp(this.z);
        }
        if (this.a.length == 1 && this.b.length == 0) {
            return ApcomplexMath.pow(this.one.subtract(this.z), this.a[0].negate());
        }
        if (this.a.length == 0 && this.b.length == 1) {
            return this.hypergeometric0F1(this.b[0], this.z);
        }
        if (this.a.length == 1 && this.b.length == 1) {
            return this.hypergeometric1F1(this.a[0], this.b[0], this.z);
        }
        assert (this.b.length > 0);
        result = this.evaluate(this.a, this.b, this.z);
        return result;
    }

    private Apcomplex hypergeometric0F1(Apcomplex b, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        if (ApcomplexMath.abs(z).doubleValue() > (double)this.targetPrecision * Math.log(this.radix)) {
            Apcomplex result;
            Apint two = new Apint(2L, this.radix);
            Apint four = new Apint(4L, this.radix);
            Aprational half = new Aprational(this.one, two);
            Apcomplex b12 = this.ensurePrecision(b.subtract(half));
            if (ApcomplexMath.isNonPositiveInteger(b12)) {
                long digitLoss = this.workingPrecision;
                this.workingPrecision = Util.ifFinite(this.workingPrecision, this.workingPrecision + digitLoss);
                Apfloat offset = this.offset(-digitLoss);
                b = new Apcomplex(b.real().precision(Long.MAX_VALUE).add(offset), b.imag());
                b = this.ensurePrecision(b);
                z = this.ensurePrecision(z);
                b12 = this.ensurePrecision(b.subtract(half));
            }
            Apcomplex b21 = this.ensurePrecision(two.multiply(b).subtract(this.one));
            if (z.real().signum() >= 0) {
                Apcomplex sqrtZ = ApcomplexMath.sqrt(z);
                result = ApcomplexMath.exp(two.negate().multiply(sqrtZ)).multiply(this.hypergeometric1F1(b12, b21, four.multiply(sqrtZ)));
            } else {
                Apcomplex i = new Apcomplex(this.zero, this.one);
                Apcomplex sqrtZ = ApcomplexMath.sqrt(z.negate());
                result = ApcomplexMath.exp(two.negate().multiply(i).multiply(sqrtZ)).multiply(this.hypergeometric1F1(b12, b21, four.multiply(i).multiply(sqrtZ)));
            }
            return result;
        }
        Apcomplex result = this.evaluate(new Apcomplex[0], new Apcomplex[]{b}, z);
        return result;
    }

    private Apcomplex hypergeometric1F1(Apcomplex a, Apcomplex b, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        if (ApcomplexMath.abs(z).doubleValue() > (double)this.targetPrecision * Math.log(this.radix)) {
            try {
                Apcomplex ba = this.ensurePrecision(b.subtract(a));
                Apcomplex result = this.zero;
                if (!ApcomplexMath.isNonPositiveInteger(ba)) {
                    result = ApcomplexMath.pow(z.negate(), a.negate()).divide(ApcomplexMath.gamma(this.ensureGammaPrecision(ba))).multiply(this.hypergeometricUStar(a, b, z));
                }
                result = result.add(ApcomplexMath.pow(z, ba.negate()).multiply(ApcomplexMath.exp(z)).divide(ApcomplexMath.gamma(this.ensureGammaPrecision(a))).multiply(this.hypergeometricUStar(ba, b, z.negate()))).multiply(ApcomplexMath.gamma(this.ensureGammaPrecision(b)));
                return result;
            }
            catch (NotConvergingException ba) {
                // empty catch block
            }
        }
        Apcomplex result = this.hypergeometric1F1series(a, b, z);
        return result;
    }

    private Apcomplex hypergeometric1F1series(Apcomplex a, Apcomplex b, Apcomplex z) {
        if (a.equals(b) && !ApcomplexMath.isNonPositiveInteger(a)) {
            return ApcomplexMath.exp(z);
        }
        Apcomplex factor = this.one;
        if (z.real().signum() < 0) {
            factor = ApcomplexMath.exp(z);
            a = this.ensurePrecision(b.subtract(a));
            z = z.negate();
        }
        Apcomplex result = this.evaluate(new Apcomplex[]{a}, new Apcomplex[]{b}, z).multiply(factor);
        return result;
    }

    private Apcomplex hypergeometricUStar(Apcomplex a, Apcomplex b, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        Apcomplex ab1 = this.ensurePrecision(a.subtract(b).add(this.one));
        Apcomplex result = this.evaluate(new Apcomplex[]{a, ab1}, new Apcomplex[0], this.one.divide(z).negate());
        return result;
    }

    private Apcomplex hypergeometricU(boolean fastOnly) throws ArithmeticException, ApfloatRuntimeException {
        Apcomplex result;
        long precisionLoss;
        block10: {
            if (ApcomplexMath.abs(this.z).doubleValue() > (double)this.targetPrecision * Math.log(this.radix)) {
                try {
                    Apcomplex result2 = ApcomplexMath.pow(this.z, this.a[0].negate()).multiply(this.hypergeometricUStar(this.a[0], this.b[0], this.z));
                    return result2;
                }
                catch (NotConvergingException nce) {
                    if (!fastOnly) break block10;
                    return null;
                }
            }
        }
        if (fastOnly && (HypergeometricHelper.stream(this.a, this.b).map(Apcomplex::real).reduce(ApfloatMath::min).get().doubleValue() < -100.0 * (double)this.targetPrecision || (double)this.z.scale() > 5.0 / Math.log(this.radix))) {
            return null;
        }
        do {
            Apcomplex a = this.a[0];
            Apcomplex b = this.b[0];
            a = this.ensurePrecision(a);
            b = this.ensurePrecision(b);
            this.z = this.ensurePrecision(this.z);
            if (b.isInteger()) {
                long digitLoss = this.workingPrecision;
                this.workingPrecision = Util.ifFinite(this.workingPrecision, this.workingPrecision + digitLoss);
                Apfloat offset = this.offset(-digitLoss);
                b = new Apcomplex(b.real().precision(Long.MAX_VALUE).add(offset), b.imag());
                a = this.ensurePrecision(a);
                b = this.ensurePrecision(b);
                this.z = this.ensurePrecision(this.z);
            } else {
                Apint bRounded = RoundingHelper.roundToInteger(b.real(), RoundingMode.HALF_EVEN);
                long digitLoss = Math.min(this.workingPrecision, -b.subtract(bRounded).scale());
                if (digitLoss > 0L) {
                    this.workingPrecision = Util.ifFinite(this.workingPrecision, this.workingPrecision + digitLoss);
                    a = this.ensurePrecision(a);
                    b = this.ensurePrecision(b);
                    this.z = this.ensurePrecision(this.z);
                }
            }
            Apcomplex ab1 = this.ensureGammaPrecision(a.subtract(b).add(this.one));
            result = this.zero;
            if (!ApcomplexMath.isNonPositiveInteger(ab1)) {
                Apcomplex b1n = this.ensureGammaPrecision(this.one.subtract(b));
                result = ApcomplexMath.gamma(b1n).divide(ApcomplexMath.gamma(ab1)).multiply(this.hypergeometric1F1series(a, b, this.z));
            }
            if (!ApcomplexMath.isNonPositiveInteger(a)) {
                Apint two = new Apint(2L, this.radix);
                Apcomplex b1 = this.ensureGammaPrecision(b.subtract(this.one));
                Apcomplex b1n = this.ensurePrecision(this.one.subtract(b));
                Apcomplex b2 = this.ensurePrecision(two.subtract(b));
                a = this.ensureGammaPrecision(a);
                result = result.add(ApcomplexMath.gamma(b1).divide(ApcomplexMath.gamma(a)).multiply(ApcomplexMath.pow(this.z, b1n)).multiply(this.hypergeometric1F1series(ab1, b2, this.z)));
            }
            precisionLoss = result.isZero() ? this.workingPrecision : this.targetPrecision - result.precision();
            this.workingPrecision = Util.ifFinite(this.workingPrecision, this.workingPrecision + precisionLoss);
        } while (precisionLoss > 0L);
        return result;
    }

    private Apcomplex hypergeometric2F1(Apcomplex a, Apcomplex b, Apcomplex c, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        Apcomplex result;
        if (z.equals(this.one)) {
            if (a.real().add(b.real()).subtract(c.real()).signum() >= 0) {
                throw new ApfloatArithmeticException("Series does not converge", "hypergeometric.nonconvergence", new Object[0]);
            }
            Apcomplex s = c.subtract(a);
            Apcomplex t2 = c.subtract(b);
            if (ApcomplexMath.isNonPositiveInteger(s) || ApcomplexMath.isNonPositiveInteger(t2)) {
                return this.zero;
            }
            Apcomplex cab = s.subtract(b);
            s = ApfloatHelper.ensureGammaPrecision(s, this.workingPrecision);
            t2 = ApfloatHelper.ensureGammaPrecision(t2, this.workingPrecision);
            cab = ApfloatHelper.ensureGammaPrecision(cab, this.workingPrecision);
            c = ApfloatHelper.ensureGammaPrecision(c, this.workingPrecision);
            return ApcomplexMath.gamma(c).multiply(ApcomplexMath.gamma(cab)).divide(ApcomplexMath.gamma(s).multiply(ApcomplexMath.gamma(t2)));
        }
        Apcomplex zDoublePrecision = z.precision(ApfloatHelper.getDoublePrecision(this.radix));
        Transformation transformation = Arrays.stream(Transformation.values()).filter(t -> t.isApplicable(z)).min(Comparator.comparing(t -> ApcomplexMath.abs(t.z(zDoublePrecision)))).get();
        if (ApcomplexMath.abs(transformation.z(zDoublePrecision)).doubleValue() > 0.8) {
            result = this.alternative(a, b, c, z);
        } else {
            result = null;
            try {
                result = transformation.value(new Hypergeometric2F1Helper(true));
            }
            catch (RetryException re) {
                this.workingPrecision = Util.ifFinite(this.workingPrecision, this.workingPrecision + re.getPrecisionLoss());
                result = transformation.value(new Hypergeometric2F1Helper(false));
            }
        }
        return result;
    }

    private static Stream<Apcomplex> stream(Apcomplex[] z0, Apcomplex ... z1) {
        return Stream.concat(Arrays.stream(z0), Arrays.stream(z1));
    }

    private static Stream<Apcomplex> stream(Apcomplex[] z0, Apcomplex[] z1, Apcomplex ... z2) {
        return Stream.concat(HypergeometricHelper.stream(z0, z1), Arrays.stream(z2));
    }

    private static long precision(Apcomplex[] z0, Apcomplex[] z1, Apcomplex ... z2) {
        Apcomplex[] z = (Apcomplex[])HypergeometricHelper.stream(z0, z1, z2).toArray(Apcomplex[]::new);
        return HypergeometricHelper.precision(z);
    }

    private static long precision(Apcomplex ... z) {
        return Arrays.stream(z).mapToLong(Apcomplex::precision).min().getAsLong();
    }

    private Apcomplex checkResult() {
        Apfloat minNonPositiveIntegerA = HypergeometricHelper.maxNonPositiveInteger(this.a);
        Apfloat minNonPositiveIntegerB = HypergeometricHelper.maxNonPositiveInteger(this.b);
        if (minNonPositiveIntegerB != null && (minNonPositiveIntegerA == null || minNonPositiveIntegerA.compareTo(minNonPositiveIntegerB) < 0)) {
            throw new ApfloatArithmeticException("Division by zero", "divide.byZero", new Object[0]);
        }
        if (this.z.isZero()) {
            return new Apfloat(1L, this.targetPrecision, this.radix);
        }
        if (this.targetPrecision == Long.MAX_VALUE) {
            throw new InfiniteExpansionException("Cannot calculate hypergeometric function to infinite precision", "hypergeometric.infinitePrecision", new Object[0]);
        }
        if (minNonPositiveIntegerA != null) {
            Apcomplex result = this.evaluate(this.a, this.b, this.z);
            return result;
        }
        return null;
    }

    public static Apfloat maxNonPositiveInteger(Apcomplex ... a) {
        return Arrays.stream(a).filter(Apcomplex::isInteger).map(Apcomplex::real).filter(x -> x.signum() <= 0).reduce(ApfloatMath::max).orElse(null);
    }

    private Apcomplex evaluate(Apcomplex[] a, Apcomplex[] b, Apcomplex z) {
        Apcomplex s;
        long extraPrecision;
        Apcomplex[] aOrig = (Apcomplex[])a.clone();
        Apcomplex[] bOrig = (Apcomplex[])b.clone();
        Apint minN = ApintMath.max(this.one, HypergeometricHelper.stream(a, b).map(Apcomplex::real).reduce(ApfloatMath::min).get().truncate().negate()).add(this.one);
        long precisionLoss = 0L;
        long extendedPrecision = ApfloatHelper.extendPrecision(this.workingPrecision, minN.scale());
        boolean divergentSeries = a.length - b.length > 1;
        this.ensurePrecision(a, a, extendedPrecision);
        this.ensurePrecision(b, b, extendedPrecision);
        z = ApfloatHelper.ensurePrecision(z, extendedPrecision);
        do {
            boolean minIterations;
            Apint[] startTerm = this.startTerm(a, b, z, minN, extendedPrecision);
            long maxSScale = 1L;
            Apint i = this.zero;
            Apcomplex numerator = this.one;
            Apcomplex denominator = this.one;
            Apcomplex o = null;
            Apcomplex t = null;
            extraPrecision = precisionLoss;
            s = this.one;
            do {
                int j;
                int iCompareMinN;
                boolean bl = minIterations = (iCompareMinN = i.compareTo(minN)) <= 0;
                if (divergentSeries && !minIterations) {
                    this.checkDivergence(o, t);
                }
                if (iCompareMinN == 0 && startTerm != null) {
                    i = startTerm[0];
                    this.ensurePrecision(aOrig, a, extendedPrecision);
                    this.ensurePrecision(bOrig, b, extendedPrecision);
                    numerator = HypergeometricHelper.pochhammerProduct(a, i).multiply(ApcomplexMath.pow(z, i));
                    denominator = HypergeometricHelper.pochhammerProduct(b, i).multiply(this.factorial(i));
                    for (j = 0; j < a.length; ++j) {
                        a[j] = a[j].add(i);
                    }
                    for (j = 0; j < b.length; ++j) {
                        b[j] = b[j].add(i);
                    }
                    minN = startTerm[1];
                    startTerm = null;
                    t = null;
                } else {
                    i = i.add(this.one);
                    for (j = 0; j < a.length; ++j) {
                        numerator = numerator.multiply(a[j]);
                        a[j] = a[j].add(this.one);
                    }
                    if (numerator.isZero()) {
                        return s;
                    }
                    numerator = numerator.multiply(z);
                    for (j = 0; j < b.length; ++j) {
                        denominator = denominator.multiply(b[j]);
                        b[j] = b[j].add(this.one);
                    }
                    denominator = denominator.multiply(i);
                }
                o = t;
                t = numerator.divide(denominator);
                s = s.add(t);
                maxSScale = Math.max(maxSScale, s.scale());
            } while (minIterations || s.isZero() || s.scale() - t.scale() <= this.workingPrecision);
            long l = precisionLoss = s.isZero() ? extendedPrecision : maxSScale - s.scale();
            if (this.workingPrecision - s.precision() > 1L) {
                precisionLoss = Util.ifFinite(precisionLoss, precisionLoss + this.workingPrecision - s.precision());
            }
            if (precisionLoss <= extraPrecision) continue;
            extendedPrecision = Util.ifFinite(this.workingPrecision, this.workingPrecision + precisionLoss);
            this.ensurePrecision(aOrig, a, extendedPrecision);
            this.ensurePrecision(bOrig, b, extendedPrecision);
            z = ApfloatHelper.ensurePrecision(z, extendedPrecision);
        } while (precisionLoss > extraPrecision);
        return s;
    }

    private void checkDivergence(Apcomplex old, Apcomplex term) {
        if (old != null && ApcomplexMath.norm(old).compareTo(ApcomplexMath.norm(term)) < 0) {
            throw new NotConvergingException();
        }
    }

    private Apint[] startTerm(Apcomplex[] a, Apcomplex[] b, Apcomplex z, Apint minN, long precision) {
        long n;
        long termScale;
        long scaleDiff;
        long low;
        Apfloat denominator;
        Apint n2;
        Apfloat numerator;
        boolean increasing;
        if (a.length > b.length || z.scale() <= 0L) {
            return null;
        }
        a = this.doublePrecision(a);
        b = this.doublePrecision(b);
        z = this.doublePrecision(z);
        long base = minN.longValueExact();
        long high = 1L;
        do {
            low = high;
        } while (increasing = (numerator = ApcomplexMath.norm(this.addProduct(a, n2 = new Apint(base + (high = Util.multiplyExact(high, 2L)), this.radix)).multiply(z))).compareTo(denominator = ApcomplexMath.norm(this.addProduct(b, n2).multiply(n2))) > 0);
        while (high - low > 1L) {
            Apfloat denominator2;
            long mid = high + low >>> 1;
            Apint n3 = new Apint(base + mid, this.radix);
            Apfloat numerator2 = ApcomplexMath.norm(this.addProduct(a, n3).multiply(z));
            boolean bl = increasing = numerator2.compareTo(denominator2 = ApcomplexMath.norm(this.addProduct(b, n3).multiply(n3))) > 0;
            if (increasing) {
                low = mid;
                continue;
            }
            high = mid;
        }
        if (low < precision) {
            return null;
        }
        long largest = base + low;
        long maxScale = this.termScale(a, b, z, largest);
        high = 1L;
        do {
            low = high;
            n = largest - (high = Util.multiplyExact(high, 2L));
            if (n >= base) continue;
            return null;
        } while ((scaleDiff = maxScale - (termScale = this.termScale(a, b, z, n))) < precision);
        while (high - low > 1L) {
            long mid = high + low >>> 1;
            long n4 = largest - mid;
            long termScale2 = this.termScale(a, b, z, n4);
            scaleDiff = maxScale - termScale2;
            if (scaleDiff < precision) {
                low = mid;
                continue;
            }
            high = mid;
        }
        if (largest - base - high < precision) {
            return null;
        }
        Apint[] values = new Apint[]{new Apint(largest - high, this.radix), new Apint(largest, this.radix)};
        return values;
    }

    private Apcomplex[] doublePrecision(Apcomplex[] a) {
        return (Apcomplex[])Arrays.stream(a).map(this::doublePrecision).toArray(Apcomplex[]::new);
    }

    private Apcomplex doublePrecision(Apcomplex a) {
        return ApfloatHelper.limitPrecision(a, (long)ApfloatHelper.getDoublePrecision(a.radix()));
    }

    private Apcomplex addProduct(Apcomplex[] a, Apint n) {
        return Arrays.stream(a).map(n::add).reduce(Apcomplex::multiply).orElse(this.one);
    }

    private long termScale(Apcomplex[] a, Apcomplex[] b, Apcomplex z, long n) {
        Apfloat nn = new Apfloat(n, z.precision(), z.radix());
        Apcomplex term = ApcomplexMath.pow(z, nn).multiply(HypergeometricHelper.pochhammerProduct(a, nn)).divide(HypergeometricHelper.pochhammerProduct(b, nn).multiply(this.factorial(nn)));
        return term.scale();
    }

    private Apfloat factorial(Apfloat n) {
        return ApfloatMath.gamma(n.add(this.one));
    }

    private Apcomplex alternative(Apcomplex a, Apcomplex b, Apcomplex c, Apcomplex z) {
        Apint cRounded;
        long digitLoss;
        if (c.real().signum() <= 0 && (digitLoss = -c.subtract(cRounded = RoundingHelper.roundToInteger(c.real(), RoundingMode.HALF_EVEN)).scale()) > 0L) {
            this.workingPrecision = Util.ifFinite(this.workingPrecision, this.workingPrecision + digitLoss);
            a = this.ensurePrecision(a);
            b = this.ensurePrecision(b);
            c = this.ensurePrecision(c);
            z = this.ensurePrecision(z);
        }
        Apint two = new Apint(2L, this.radix);
        Apint four = new Apint(4L, this.radix);
        Apint k = this.zero;
        Apcomplex d = this.zero;
        Apcomplex e = this.one;
        Apcomplex f = this.zero;
        Apcomplex z1 = this.ensurePrecision(this.one.subtract(z));
        Apcomplex z12 = two.multiply(z1);
        Apcomplex z2 = this.ensurePrecision(z.subtract(two));
        Apcomplex abz = a.multiply(b).multiply(z);
        Apcomplex c2 = c.divide(two);
        Apcomplex c12 = this.ensurePrecision(c.add(this.one)).divide(two);
        Apcomplex cba = this.ensurePrecision(c.subtract(b).subtract(a));
        assert (c2.real().signum() > 0 || c2.imag().signum() != 0 || !c2.isInteger());
        do {
            Apcomplex kc2 = k.add(c2);
            Apcomplex kakbz = k.add(a).multiply(k.add(b)).multiply(z);
            Apcomplex divisor = this.one.divide(four.multiply(k.add(this.one)).multiply(kc2).multiply(k.add(c12)));
            Apcomplex d1 = kakbz.multiply(e.subtract(k.add(cba).multiply(d).multiply(z).divide(z1))).multiply(divisor);
            Apcomplex e1 = kakbz.multiply(abz.multiply(d).divide(z1).add(k.add(c).multiply(e))).multiply(divisor);
            Apcomplex f1 = f.subtract(d.multiply(k.multiply(cba.multiply(z).add(k.multiply(z2)).subtract(c)).subtract(abz)).divide(kc2.multiply(z12))).add(e);
            d = this.ensurePrecision(d1);
            e = this.ensurePrecision(e1);
            f = this.ensurePrecision(f1);
            k = k.add(this.one);
        } while (d.scale() >= -this.workingPrecision || e.scale() >= -this.workingPrecision);
        return f;
    }

    private Apfloat offset(long scale) {
        Apfloat offset = ApfloatMath.scale(new Apfloat("0.1", this.workingPrecision, this.radix), scale);
        return offset;
    }

    private Apfloat adjustOffset(Apfloat x, Apfloat offset) {
        if (x.scale() <= offset.scale()) {
            return x;
        }
        return x.precision(Long.MAX_VALUE).add(offset).subtract(offset);
    }

    private Apcomplex ensurePrecision(Apcomplex z) {
        return ApfloatHelper.ensurePrecision(z, this.workingPrecision);
    }

    private void ensurePrecision(Apcomplex[] src, Apcomplex[] dest, long extendedPrecision) {
        for (int i = 0; i < dest.length; ++i) {
            dest[i] = ApfloatHelper.ensurePrecision(src[i], extendedPrecision);
        }
    }

    private Apcomplex ensureGammaPrecision(Apcomplex z) {
        return ApfloatHelper.ensureGammaPrecision(z, this.workingPrecision);
    }

    private static long reducePrecision(Apcomplex z0, Apcomplex ... z1) {
        return Math.max(2L, HypergeometricHelper.stream(z1, z0).mapToLong(Apcomplex::scale).max().getAsLong()) - 2L;
    }

    public static long ensureHypergeometricPrecision(Apcomplex z, long precision) {
        return ApfloatHelper.extendPrecision(precision, HypergeometricHelper.reducePrecision(z, new Apcomplex[0]));
    }

    private Apcomplex result(Apcomplex z) {
        if (z == null) {
            return z;
        }
        long precision = ApfloatHelper.reducePrecision(this.targetPrecision, this.reducePrecision);
        z = ApfloatHelper.limitPrecision(z, precision);
        return ApfloatHelper.reducePrecision(z, this.extraPrecision);
    }

    private static class NotConvergingException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private NotConvergingException() {
        }
    }

    private static enum Transformation {
        T0{

            @Override
            public boolean isApplicable(Apcomplex z) {
                return true;
            }

            @Override
            public Apcomplex z(Apcomplex z) {
                return z;
            }

            @Override
            public Apcomplex value(Hypergeometric2F1Helper helper) {
                Apcomplex a = helper.a;
                Apcomplex b = helper.b;
                Apcomplex c = helper.c;
                Apcomplex z = helper.z;
                return helper.evaluate(a, b, c, z);
            }
        }
        ,
        T1{

            @Override
            public boolean isApplicable(Apcomplex z) {
                return !z.equals(Apint.ONES[z.radix()]);
            }

            @Override
            public Apcomplex z(Apcomplex z) {
                Apint one = Apint.ONES[z.radix()];
                return z.divide(z.subtract(one));
            }

            @Override
            public Apcomplex value(Hypergeometric2F1Helper helper) {
                Apint one = helper.one;
                Apcomplex a = helper.a;
                Apcomplex b = helper.b;
                Apcomplex c = helper.c;
                Apcomplex z = helper.z;
                Apcomplex z1 = one.subtract(z);
                Apcomplex s = c.subtract(a);
                Apcomplex t = c.subtract(b);
                if (ApcomplexMath.isNonPositiveInteger(s) && (!ApcomplexMath.isNonPositiveInteger(t) || s.real().compareTo(t.real()) >= 0)) {
                    return ApcomplexMath.pow(z1, b.negate()).multiply(helper.evaluate(s, b, c, this.z(z)));
                }
                return ApcomplexMath.pow(z1, a.negate()).multiply(helper.evaluate(a, t, c, this.z(z)));
            }
        }
        ,
        T2{

            @Override
            public boolean isApplicable(Apcomplex z) {
                return !z.isZero();
            }

            @Override
            public Apcomplex z(Apcomplex z) {
                Apint one = Apint.ONES[z.radix()];
                return one.divide(z);
            }

            @Override
            public Apcomplex value(Hypergeometric2F1Helper helper) {
                helper.adjustIntegerAB();
                Apint one = helper.one;
                Apcomplex a = helper.a;
                Apcomplex b = helper.b;
                Apcomplex c = helper.c;
                Apcomplex z = helper.z;
                return helper.transform(b.subtract(a), c, z.negate(), a.negate(), b, c.subtract(a), a, a.subtract(c).add(one), a.subtract(b).add(one), z.negate(), b.negate(), one, one, a, c.subtract(b), b, b.subtract(c).add(one), b.subtract(a).add(one), this.z(z));
            }
        }
        ,
        T3{

            @Override
            public boolean isApplicable(Apcomplex z) {
                return !z.equals(Apint.ONES[z.radix()]);
            }

            @Override
            public Apcomplex z(Apcomplex z) {
                Apint one = Apint.ONES[z.radix()];
                return one.divide(one.subtract(z));
            }

            @Override
            public Apcomplex value(Hypergeometric2F1Helper helper) {
                helper.adjustIntegerAB();
                Apint one = helper.one;
                Apcomplex a = helper.a;
                Apcomplex b = helper.b;
                Apcomplex c = helper.c;
                Apcomplex z = helper.z;
                return helper.transform(b.subtract(a), c, one.subtract(z), a.negate(), b, c.subtract(a), a, c.subtract(b), a.subtract(b).add(one), one.subtract(z), b.negate(), one, one, a, c.subtract(b), b, c.subtract(a), b.subtract(a).add(one), this.z(z));
            }
        }
        ,
        T4{

            @Override
            public boolean isApplicable(Apcomplex z) {
                return true;
            }

            @Override
            public Apcomplex z(Apcomplex z) {
                Apint one = Apint.ONES[z.radix()];
                return one.subtract(z);
            }

            @Override
            public Apcomplex value(Hypergeometric2F1Helper helper) {
                helper.adjustIntegerCAB();
                Apint one = helper.one;
                Apcomplex a = helper.a;
                Apcomplex b = helper.b;
                Apcomplex c = helper.c;
                Apcomplex z = helper.z;
                return helper.transform(c.subtract(b).subtract(a), c, one, one, c.subtract(a), c.subtract(b), a, b, a.add(b).subtract(c).add(one), one.subtract(z), c.subtract(a).subtract(b), one, one, a, b, c.subtract(a), c.subtract(b), c.subtract(a).subtract(b).add(one), this.z(z));
            }
        }
        ,
        T5{

            @Override
            public boolean isApplicable(Apcomplex z) {
                return !z.isZero();
            }

            @Override
            public Apcomplex z(Apcomplex z) {
                Apint one = Apint.ONES[z.radix()];
                return one.subtract(one.divide(z));
            }

            @Override
            public Apcomplex value(Hypergeometric2F1Helper helper) {
                helper.adjustIntegerCAB();
                Apint one = helper.one;
                Apcomplex a = helper.a;
                Apcomplex b = helper.b;
                Apcomplex c = helper.c;
                Apcomplex z = helper.z;
                return helper.transform(c.subtract(b).subtract(a), c, z, a.negate(), c.subtract(a), c.subtract(b), a, a.subtract(c).add(one), a.add(b).subtract(c).add(one), one.subtract(z), c.subtract(a).subtract(b), z, a.subtract(c), a, b, c.subtract(a), one.subtract(a), c.subtract(a).subtract(b).add(one), this.z(z));
            }
        };


        public abstract boolean isApplicable(Apcomplex var1);

        public abstract Apcomplex z(Apcomplex var1);

        public abstract Apcomplex value(Hypergeometric2F1Helper var1);
    }

    private class Hypergeometric2F1Helper {
        public Apcomplex a;
        public Apcomplex b;
        public Apcomplex c;
        public Apcomplex z;
        public Apint one;
        private boolean retry;

        public Hypergeometric2F1Helper(boolean retry) {
            this.a = HypergeometricHelper.this.a[0];
            this.b = HypergeometricHelper.this.a[1];
            this.c = HypergeometricHelper.this.b[0];
            this.z = HypergeometricHelper.this.z;
            this.one = HypergeometricHelper.this.one;
            this.retry = retry;
        }

        public void ensurePrecisions() {
            this.a = HypergeometricHelper.this.ensurePrecision(this.a);
            this.b = HypergeometricHelper.this.ensurePrecision(this.b);
            this.c = HypergeometricHelper.this.ensurePrecision(this.c);
            this.z = HypergeometricHelper.this.ensurePrecision(this.z);
        }

        public void adjustIntegerAB() {
            Apcomplex ab = this.a.subtract(this.b);
            if (ab.isInteger()) {
                this.swapLargerAB();
                long digitLoss = HypergeometricHelper.this.workingPrecision;
                HypergeometricHelper.this.workingPrecision = Util.ifFinite(HypergeometricHelper.this.workingPrecision, HypergeometricHelper.this.workingPrecision + digitLoss);
                Apfloat offset = HypergeometricHelper.this.offset(-digitLoss);
                if (!this.b.equals(offset)) {
                    this.a = new Apcomplex(this.a.real().precision(Long.MAX_VALUE).add(offset), this.a.imag());
                }
                this.b = new Apcomplex(HypergeometricHelper.this.adjustOffset(this.b.real(), offset), this.b.imag());
                this.ensurePrecisions();
            } else {
                Apint abRounded = RoundingHelper.roundToInteger(ab.real(), RoundingMode.HALF_EVEN);
                long digitLoss = Math.min(HypergeometricHelper.this.workingPrecision, -ab.subtract(abRounded).scale());
                if (digitLoss > 0L) {
                    HypergeometricHelper.this.workingPrecision = Util.ifFinite(HypergeometricHelper.this.workingPrecision, HypergeometricHelper.this.workingPrecision + digitLoss);
                    Apfloat offset = HypergeometricHelper.this.offset(-digitLoss);
                    this.a = new Apcomplex(HypergeometricHelper.this.adjustOffset(this.a.real(), offset), this.a.imag());
                    this.b = new Apcomplex(HypergeometricHelper.this.adjustOffset(this.b.real(), offset), this.b.imag());
                    this.ensurePrecisions();
                }
            }
        }

        public void adjustIntegerCAB() {
            Apcomplex cab = this.c.subtract(this.a).subtract(this.b);
            if (cab.isInteger()) {
                Apcomplex aOrig = this.a;
                Apcomplex bOrig = this.b;
                Apcomplex cOrig = this.c;
                this.swapLargerAB();
                long digitLoss = HypergeometricHelper.this.workingPrecision;
                HypergeometricHelper.this.workingPrecision = Util.ifFinite(HypergeometricHelper.this.workingPrecision, HypergeometricHelper.this.workingPrecision + digitLoss);
                Apfloat offset = HypergeometricHelper.this.offset(-digitLoss);
                if (this.c.real().scale() > this.a.real().scale()) {
                    this.c = new Apcomplex(this.c.real().precision(Long.MAX_VALUE).add(offset), this.c.imag());
                    this.a = new Apcomplex(HypergeometricHelper.this.adjustOffset(this.a.real(), offset), this.a.imag());
                } else {
                    this.c = new Apcomplex(HypergeometricHelper.this.adjustOffset(this.c.real(), offset), this.c.imag());
                    this.a = new Apcomplex(this.a.real().precision(Long.MAX_VALUE).add(offset), this.a.imag());
                }
                this.b = new Apcomplex(HypergeometricHelper.this.adjustOffset(this.b.real(), offset), this.b.imag());
                this.ensurePrecisions();
                if (this.c.subtract(this.a).subtract(this.b).isInteger()) {
                    this.a = aOrig;
                    this.b = bOrig;
                    this.c = cOrig;
                    this.ensurePrecisions();
                    assert (!this.c.subtract(this.a).subtract(this.b).isInteger());
                }
            } else {
                Apint cabRounded = RoundingHelper.roundToInteger(cab.real(), RoundingMode.HALF_EVEN);
                long digitLoss = Math.min(HypergeometricHelper.this.workingPrecision, -cab.subtract(cabRounded).scale());
                if (digitLoss > 0L) {
                    HypergeometricHelper.this.workingPrecision = Util.ifFinite(HypergeometricHelper.this.workingPrecision, HypergeometricHelper.this.workingPrecision + digitLoss);
                    Apfloat offset = HypergeometricHelper.this.offset(-digitLoss);
                    this.a = new Apcomplex(HypergeometricHelper.this.adjustOffset(this.a.real(), offset), this.a.imag());
                    this.b = new Apcomplex(HypergeometricHelper.this.adjustOffset(this.b.real(), offset), this.b.imag());
                    this.c = new Apcomplex(HypergeometricHelper.this.adjustOffset(this.c.real(), offset), this.c.imag());
                    this.ensurePrecisions();
                }
            }
        }

        private void swapLargerAB() {
            if (this.a.real().scale() < this.b.real().scale()) {
                Apcomplex tmp = this.a;
                this.a = this.b;
                this.b = tmp;
            }
        }

        public Apcomplex transform(Apcomplex s, Apcomplex c, Apcomplex base1, Apcomplex exp1, Apcomplex g1, Apcomplex g2, Apcomplex a1, Apcomplex b1, Apcomplex c1, Apcomplex base2, Apcomplex exp2, Apcomplex base3, Apcomplex exp3, Apcomplex g3, Apcomplex g4, Apcomplex a2, Apcomplex b2, Apcomplex c2, Apcomplex z) {
            long precisionLoss;
            Apcomplex term1 = ApcomplexMath.isNonPositiveInteger(g1) || ApcomplexMath.isNonPositiveInteger(g2) ? HypergeometricHelper.this.zero : ApcomplexMath.pow(base1, exp1).divide(ApcomplexMath.gamma(g1).multiply(ApcomplexMath.gamma(g2)).multiply(ApcomplexMath.gamma(c1))).multiply(this.evaluate(a1, b1, c1, z));
            Apcomplex term2 = ApcomplexMath.isNonPositiveInteger(g3) || ApcomplexMath.isNonPositiveInteger(g4) ? HypergeometricHelper.this.zero : ApcomplexMath.pow(base2, exp2).multiply(ApcomplexMath.pow(base3, exp3)).divide(ApcomplexMath.gamma(g3).multiply(ApcomplexMath.gamma(g4)).multiply(ApcomplexMath.gamma(c2))).multiply(this.evaluate(a2, b2, c2, z));
            Apcomplex d = term1.subtract(term2);
            long l = precisionLoss = d.isZero() ? HypergeometricHelper.this.workingPrecision : HypergeometricHelper.this.targetPrecision - d.precision();
            if (this.retry && precisionLoss > 1L) {
                throw new RetryException(precisionLoss);
            }
            Apfloat pi = ApfloatMath.pi(HypergeometricHelper.this.workingPrecision, HypergeometricHelper.this.radix);
            return ApcomplexMath.gamma(c).multiply(pi).divide(ApcomplexMath.sin(pi.multiply(s))).multiply(d);
        }

        private Apcomplex evaluate(Apcomplex a, Apcomplex b, Apcomplex c, Apcomplex z) {
            return HypergeometricHelper.this.evaluate(new Apcomplex[]{a, b}, new Apcomplex[]{c}, z);
        }
    }

    private static class RetryException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private long precisionLoss;

        public RetryException(long precisionLoss) {
            this.precisionLoss = precisionLoss;
        }

        public long getPrecisionLoss() {
            return this.precisionLoss;
        }
    }
}

