/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.internal.DoubleBaseMath;
import org.apfloat.internal.DoubleRadixConstants;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DoubleCRTMath
extends DoubleBaseMath {
    private static final long serialVersionUID = -8414531999881223922L;
    private static final double INVERSE_MAX_POWER_OF_TWO_BASE = 4.440892098500626E-16;
    private long base;
    private double inverseBase;

    public DoubleCRTMath(int radix) {
        super(radix);
        this.base = (long)DoubleRadixConstants.BASE[radix];
        this.inverseBase = 1.0 / DoubleRadixConstants.BASE[radix];
    }

    public final void multiply(double[] src, double factor, double[] dst) {
        double carry = Math.floor(src[1] * factor * 4.440892098500626E-16);
        double tmp = Math.fma(src[1], factor, carry * -2.251799813685248E15);
        if (tmp < 0.0) {
            carry -= 1.0;
            tmp += 2.251799813685248E15;
        }
        dst[2] = tmp;
        double c = carry;
        tmp = Math.fma(src[0], factor, (carry = Math.floor(Math.fma(src[0], factor, carry) * 4.440892098500626E-16)) * -2.251799813685248E15) + c;
        if (tmp < 0.0) {
            carry -= 1.0;
            tmp += 2.251799813685248E15;
        }
        dst[1] = tmp;
        dst[0] = carry;
    }

    public final double compare(double[] src1, double[] src2) {
        double result = src1[0] - src2[0];
        if (result != 0.0) {
            return result;
        }
        result = src1[1] - src2[1];
        if (result != 0.0) {
            return result;
        }
        return src1[2] - src2[2];
    }

    public final double add(double[] src, double[] srcDst) {
        double result = srcDst[2] + src[2];
        double carry = result >= 2.251799813685248E15 ? 1 : 0;
        srcDst[2] = result = result >= 2.251799813685248E15 ? result - 2.251799813685248E15 : result;
        result = srcDst[1] + src[1] + carry;
        carry = result >= 2.251799813685248E15 ? 1 : 0;
        srcDst[1] = result = result >= 2.251799813685248E15 ? result - 2.251799813685248E15 : result;
        result = srcDst[0] + src[0] + carry;
        carry = result >= 2.251799813685248E15 ? 1 : 0;
        srcDst[0] = result = result >= 2.251799813685248E15 ? result - 2.251799813685248E15 : result;
        return carry;
    }

    public final void subtract(double[] src, double[] srcDst) {
        double result = srcDst[2] - src[2];
        double carry = result < 0.0 ? 1 : 0;
        srcDst[2] = result = result < 0.0 ? result + 2.251799813685248E15 : result;
        result = srcDst[1] - src[1] - carry;
        carry = result < 0.0 ? 1 : 0;
        srcDst[1] = result = result < 0.0 ? result + 2.251799813685248E15 : result;
        result = srcDst[0] - src[0] - carry;
        srcDst[0] = result = result < 0.0 ? result + 2.251799813685248E15 : result;
    }

    public final double divide(double[] srcDst) {
        double result = Math.floor(Math.fma(srcDst[0], 2.251799813685248E15, srcDst[1]) * this.inverseBase);
        double carry = Math.fma(-result, (double)this.base, srcDst[0] * 2.251799813685248E15) + srcDst[1];
        if (carry >= (double)this.base) {
            carry -= (double)this.base;
            result += 1.0;
        }
        if (carry < 0.0) {
            carry += (double)this.base;
            result -= 1.0;
        }
        srcDst[0] = 0.0;
        srcDst[1] = result;
        result = Math.floor(Math.fma(carry, 2.251799813685248E15, srcDst[2]) * this.inverseBase);
        if ((carry = Math.fma(-result, (double)this.base, carry * 2.251799813685248E15) + srcDst[2]) >= (double)this.base) {
            carry -= (double)this.base;
            result += 1.0;
        }
        if (carry < 0.0) {
            carry += (double)this.base;
            result -= 1.0;
        }
        srcDst[2] = result;
        return carry;
    }
}

