/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DoubleElementaryModMath {
    private long longModulus;
    private double modulus;
    private double inverseModulus;

    public final double modMultiply(double a, double b) {
        double d = this.modulus;
        double c = Math.floor(a * b * this.inverseModulus);
        double w = d * c;
        double r = Math.fma(a, b, -w) + Math.fma(c, -d, w);
        return r >= this.modulus ? r - this.modulus : r;
    }

    public final double modAdd(double a, double b) {
        double r = a + b;
        return r >= this.modulus ? r - this.modulus : r;
    }

    public final double modSubtract(double a, double b) {
        double r = a - b;
        return r < 0.0 ? r + this.modulus : r;
    }

    public final double getModulus() {
        return this.modulus;
    }

    public final void setModulus(double modulus) {
        this.inverseModulus = 1.0 / (modulus + 0.5);
        this.longModulus = (long)modulus;
        this.modulus = modulus;
    }
}

