/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracing.level.impl.config;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.module.observability.AbstractFileObservabilitySignalConfiguration;
import org.mule.runtime.module.observability.configuration.ObservabilityConfigurationFileWatcher;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfigurationFileFinder;
import org.mule.runtime.tracing.level.api.config.TracingLevel;
import org.mule.runtime.tracing.level.api.config.TracingLevelConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTracingLevelConfiguration
extends AbstractFileObservabilitySignalConfiguration
implements TracingLevelConfiguration,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileTracingLevelConfiguration.class);
    private static final String WRONG_LEVEL_ERROR = "Wrong tracing level found in configuration file: {}. The tracing level will be set to the default level: {}";
    private static final String WRONG_LEVEL_OVERRIDE_ERROR = "Wrong tracing level override found in configuration file: {}. This override will be ignored.";
    private static final String UNEXPECTED_ERROR_WHILE_READING_FROM_CONFIGURATION_FILE = "Unexpected error while reading from configuration file.";
    public static final String CONFIGURATION_FILE_NAME = "tracing-level.conf";
    private static final String LEVEL_PROPERTY_NAME = "mule.openTelemetry.tracer.level";
    private static final String OVERRIDES_PROPERTY_NAME = "mule.openTelemetry.tracer.levelOverrides";
    private final List<Runnable> onConfigurationChangeRunnables = Collections.synchronizedList(new ArrayList());
    private TracingLevel tracingLevel;
    private Map<String, TracingLevel> tracingLevelOverrides;
    private ObservabilityConfigurationFileWatcher fileWatcher;

    private static ObservabilitySignalConfigurationFileFinder getFileFinder(MuleContext muleContext) {
        return path -> FileTracingLevelConfiguration.findArtifactConfigFile((ClassLoader)muleContext.getExecutionClassLoader(), (String)path);
    }

    public FileTracingLevelConfiguration(MuleContext muleContext) {
        super(FileTracingLevelConfiguration.getFileFinder(muleContext), muleContext.getDeploymentProperties(), muleContext.getId());
    }

    protected void onConfigurationFileNotFound() {
        LOGGER.atInfo().log("Tracing level configuration file named '{}' not found at the '{}' configuration path. Using default configuration.", (Object)this.getSignalConfigurationFileName(), (Object)this.getSignalConfigurationFileDirectoryPath());
    }

    protected void onConfigurationFileLoadError(Exception error, File configurationFile) {
        String message = String.format("Parsing error in the tracing level configuration file '%s'.", configurationFile.getAbsolutePath());
        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)message, (Object[])new Object[]{error}));
    }

    protected String getSignalConfigurationFileName() {
        return System.getProperty("mule.openTelemetry.tracer.level.configurationFileName", CONFIGURATION_FILE_NAME);
    }

    protected Path getSignalConfigurationFileDirectoryPath() {
        return Paths.get(System.getProperty("mule.openTelemetry.tracer.level.configurationFilePath", MuleFoldersUtil.getConfFolder().getAbsolutePath()), new String[0]).toAbsolutePath();
    }

    protected boolean isArtifactLevelProperty(String configurationKey) {
        return false;
    }

    public void initialise() {
        super.initialise();
        this.configureFileWatcher();
    }

    public void dispose() {
        if (this.fileWatcher != null) {
            this.fileWatcher.interrupt();
        }
    }

    private TracingLevel computeTracingLevel() {
        TracingLevel computedTracingLevel = TracingLevel.valueOf((String)System.getProperty("mule.openTelemetry.tracer.exporter.defaultTracingLevel", TracingLevel.MONITORING.toString()).toUpperCase());
        try {
            String configuredTracingLevel = this.getStringValue(LEVEL_PROPERTY_NAME);
            if (configuredTracingLevel != null) {
                try {
                    computedTracingLevel = TracingLevel.valueOf((String)configuredTracingLevel.toUpperCase(Locale.ROOT));
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error(WRONG_LEVEL_ERROR, (Object)configuredTracingLevel, (Object)computedTracingLevel);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(UNEXPECTED_ERROR_WHILE_READING_FROM_CONFIGURATION_FILE, (Throwable)e);
            throw e;
        }
        return computedTracingLevel;
    }

    private Map<String, TracingLevel> computeTracingLevelsOverrides() {
        HashMap<String, TracingLevel> computedLevelOverrides = new HashMap<String, TracingLevel>();
        try {
            this.getStringListValue(OVERRIDES_PROPERTY_NAME, Collections.emptyList()).forEach(override -> {
                String[] levelOverride = override.split("=");
                if (levelOverride.length != 2) {
                    LOGGER.error(WRONG_LEVEL_OVERRIDE_ERROR, override);
                } else {
                    try {
                        computedLevelOverrides.put(levelOverride[0], TracingLevel.valueOf((String)levelOverride[1].toUpperCase(Locale.ROOT)));
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.error(WRONG_LEVEL_OVERRIDE_ERROR, override);
                    }
                }
            });
        }
        catch (Exception e) {
            LOGGER.error(UNEXPECTED_ERROR_WHILE_READING_FROM_CONFIGURATION_FILE, (Throwable)e);
        }
        return computedLevelOverrides;
    }

    private void configureFileWatcher() {
        if (this.getConfigurationFile() != null && this.getConfigurationFile().exists() && this.fileWatcher != null) {
            this.fileWatcher = new ObservabilityConfigurationFileWatcher(this.getConfigurationFile(), () -> this.onConfigurationChangeRunnables.forEach(Runnable::run));
            this.fileWatcher.start();
        }
    }

    public TracingLevel getTracingLevel() {
        if (this.tracingLevel == null) {
            this.tracingLevel = this.computeTracingLevel();
        }
        return this.tracingLevel;
    }

    public TracingLevel getTracingLevelOverride(String location) {
        if (this.tracingLevelOverrides == null) {
            this.tracingLevelOverrides = this.computeTracingLevelsOverrides();
        }
        return this.tracingLevelOverrides.getOrDefault(location, this.getTracingLevel());
    }

    public void onConfigurationChange(Consumer<TracingLevelConfiguration> onConfigurationChangeConsumer) {
        this.onConfigurationChangeRunnables.add(() -> onConfigurationChangeConsumer.accept(this));
    }
}

