/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Frame;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.ReferenceCounted;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.util.MultiMap;
import org.mule.service.http.netty.impl.client.ReactorNettyClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class TrailersSenderHandler
extends MessageToMessageEncoder<Http2Frame> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrailersSenderHandler.class);

    protected void encode(ChannelHandlerContext ctx, Http2Frame frame, List<Object> outList) throws Exception {
        Http2DataFrame dataFrame;
        LOGGER.trace("TrailersSenderHandler#write() called with object of type: {}", (Object)(frame != null ? frame.getClass().getName() : "null"));
        if (frame instanceof ReferenceCounted) {
            ReferenceCounted rc = (ReferenceCounted)frame;
            rc.retain();
        }
        if (frame instanceof Http2DataFrame && (dataFrame = (Http2DataFrame)frame).isEndStream()) {
            MultiMap trailersMap = (MultiMap)((CompletableFuture)ctx.channel().attr(ReactorNettyClient.TRAILERS_FUTURE).get()).get();
            if (trailersMap.isEmpty()) {
                outList.add(frame);
                return;
            }
            Http2FrameStream stream = dataFrame.stream();
            DefaultHttp2DataFrame lastData = new DefaultHttp2DataFrame(dataFrame.content(), false, dataFrame.padding()).stream(stream);
            outList.add(lastData);
            DefaultHttp2Headers trailers = new DefaultHttp2Headers(false);
            trailersMap.forEach((arg_0, arg_1) -> ((DefaultHttp2Headers)trailers).add(arg_0, arg_1));
            DefaultHttp2HeadersFrame trailersFrame = new DefaultHttp2HeadersFrame((Http2Headers)trailers, true).stream(stream);
            outList.add(trailersFrame);
            return;
        }
        outList.add(frame);
    }
}

