/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.simple;

import jakarta.activation.MimetypesFileTypeMap;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.el.CompiledExpression;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.util.MuleSystemProperties;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.el.ExpressionLanguageUtils;
import org.mule.runtime.core.internal.interception.HasParamsAsTemplateProcessor;
import org.mule.runtime.core.internal.util.func.Once;
import org.mule.runtime.core.internal.util.rx.Operators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseTemplateProcessor
extends AbstractComponent
implements Processor,
Initialisable,
HasParamsAsTemplateProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParseTemplateProcessor.class);
    private static final MimetypesFileTypeMap mimetypesFileTypeMap = new MimetypesFileTypeMap();
    private static final String LEGACY_DEFAULT_TARGET_VALUE = "#[message]";
    private static final Once.RunOnce LOG_LEGACY_DEFAULT_WARN = Once.of(() -> LOGGER.warn("Property '{}' is enabled, using legacy default targetValue for parse-template component: '{}'. Consider updating the expressions that rely on this behavior and removing the property.", (Object)"mule.parse.template.use.legacy.default.targetValue", (Object)LEGACY_DEFAULT_TARGET_VALUE));
    private ExtendedExpressionManager expressionManager;
    private String content;
    private MediaType outputMimeType;
    private Charset outputEncoding;
    private String target;
    private String location;
    private String targetValue;
    private CompiledExpression targetValueExpression;

    public void initialise() throws InitialisationException {
        if (this.content != null && this.location != null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Can't define both location and content at the same time"), (Initialisable)this);
        }
        if (this.content == null && this.location == null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"One of 'location' or 'content' should be defined but they are both null"), (Initialisable)this);
        }
        if (this.location != null) {
            this.loadContentFromLocation();
            if (this.outputMimeType == null) {
                this.guessMimeType();
            }
        }
        if (this.targetValue != null) {
            this.targetValueExpression = ExpressionLanguageUtils.compile((String)this.targetValue, (ExpressionLanguage)this.expressionManager);
        }
        if (MuleSystemProperties.isParseTemplateUseLegacyDefaultTargetValue() && LEGACY_DEFAULT_TARGET_VALUE.equals(this.targetValue)) {
            LOG_LEGACY_DEFAULT_WARN.runOnce();
        }
    }

    private void loadContentFromLocation() throws InitialisationException {
        InputStream contentStream = null;
        try {
            contentStream = org.mule.runtime.core.internal.util.IOUtils.getResourceAsStream((String)this.location, ((Object)((Object)this)).getClass());
            if (contentStream == null) {
                throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)("Template location: " + this.location + " not found")), (Initialisable)this);
            }
            this.content = this.outputEncoding != null ? IOUtils.toString((InputStream)contentStream, (Charset)this.outputEncoding) : IOUtils.toString((InputStream)contentStream);
        }
        catch (IOException e) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Error loading template from location"), (Initialisable)this);
        }
        finally {
            if (contentStream != null) {
                IOUtils.closeQuietly((InputStream)contentStream);
            }
        }
    }

    private void guessMimeType() {
        MediaType fromLocationMediaType = MediaType.parse((String)mimetypesFileTypeMap.getContentType(this.location));
        if (!MediaType.BINARY.equals((Object)fromLocationMediaType)) {
            this.outputMimeType = fromLocationMediaType;
        }
    }

    private void evaluateCorrectArguments() {
        if (!(this.target != null || ExpressionLanguageUtils.isSanitizedPayload((String)org.mule.runtime.api.el.ExpressionLanguageUtils.sanitize((String)this.targetValue)) || MuleSystemProperties.isParseTemplateUseLegacyDefaultTargetValue() && LEGACY_DEFAULT_TARGET_VALUE.equals(this.targetValue))) {
            throw new IllegalArgumentException("Can't define a targetValue with no target");
        }
    }

    private MediaType buildMediaType() {
        if (this.outputMimeType != null) {
            if (this.outputEncoding != null) {
                return MediaType.create((String)this.outputMimeType.getPrimaryType(), (String)this.outputMimeType.getSubType(), (Charset)this.outputEncoding);
            }
            return this.outputMimeType;
        }
        return null;
    }

    public CoreEvent process(CoreEvent event) {
        this.evaluateCorrectArguments();
        String result = this.expressionManager.parseLogTemplate(this.content, event, this.getLocation(), BindingContextUtils.NULL_BINDING_CONTEXT);
        Message.Builder messageBuilder = Message.builder((Message)event.getMessage()).value((Object)result).nullAttributesValue();
        MediaType configuredMediaType = this.buildMediaType();
        if (configuredMediaType != null) {
            messageBuilder.mediaType(configuredMediaType);
        }
        Message resultMessage = messageBuilder.build();
        if (this.target == null) {
            return CoreEvent.builder((CoreEvent)event).message(resultMessage).build();
        }
        CoreEvent resultEvent = CoreEvent.builder((CoreEvent)event).message(resultMessage).build();
        return Operators.outputToTarget((CoreEvent)event, (CoreEvent)resultEvent, (String)this.target, (CompiledExpression)this.targetValueExpression, (ExpressionLanguage)this.expressionManager);
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setTargetValue(String targetValue) {
        this.targetValue = targetValue;
    }

    public void setOutputMimeType(String outputMimeType) {
        this.outputMimeType = MediaType.parseDefinedInApp((String)outputMimeType);
    }

    public void setOutputEncoding(String encoding) {
        this.outputEncoding = Charset.forName(encoding);
    }

    @Inject
    public void setExpressionManager(ExtendedExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
    }
}

