/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.client.sse;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.functional.junit4.matchers.ThrowableMessageMatcher;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.sse.ServerSentEvent;
import org.mule.runtime.http.api.sse.client.SseListener;
import org.mule.runtime.http.api.sse.client.SseRetryConfig;
import org.mule.runtime.http.api.sse.client.SseSourceConfig;
import org.mule.service.http.common.client.sse.DefaultSseSource;
import org.mule.service.http.common.client.sse.SseStreamConsumer;
import org.mule.service.http.common.message.sse.ServerSentEventImpl;
import org.mule.service.http.netty.impl.message.content.NettyFeedableHttpEntity;
import org.mule.service.http.netty.impl.message.content.StringHttpEntity;
import org.mule.service.http.test.common.AbstractHttpTestCase;
import org.mule.service.http.test.netty.utils.sse.SSEEventsAggregator;
import org.mule.service.http.test.netty.utils.sse.ServerSentEventTypeSafeMatcher;

@Feature(value="Server Sent Events (SSE)")
@Story(value="SSE Source")
class DefaultSseSourceTestCase
extends AbstractHttpTestCase {
    private static final SseRetryConfig DONT_RETRY_ON_EOS = new SseRetryConfig(true, 2000L, false);
    private static final String TEST_URL = "http://localhost:8080/test";
    private HttpClient mockClient;
    private Scheduler mockScheduler;
    private HttpRequestOptions mockOptions;
    private Consumer<HttpRequestBuilder> mockCustomizer;
    private SseSourceConfig configWithRetry;
    private SseSourceConfig configDontRetry;

    DefaultSseSourceTestCase() {
    }

    @BeforeEach
    void setUp() {
        this.mockScheduler = (Scheduler)Mockito.mock(Scheduler.class);
        this.mockClient = (HttpClient)Mockito.mock(HttpClient.class);
        this.mockOptions = (HttpRequestOptions)Mockito.mock(HttpRequestOptions.class);
        this.mockCustomizer = (Consumer)Mockito.mock(Consumer.class);
        this.configWithRetry = SseSourceConfig.builder((String)TEST_URL).withRequestOptions(this.mockOptions).withRequestCustomizer(this.mockCustomizer).build();
        this.configDontRetry = SseSourceConfig.builder((String)TEST_URL).withRetryConfig(DONT_RETRY_ON_EOS).withRequestOptions(this.mockOptions).withRequestCustomizer(this.mockCustomizer).build();
    }

    @Test
    void newEventSourceIsClosed() {
        try (DefaultSseSource eventSource = new DefaultSseSource(this.configDontRetry, this.mockClient, (ScheduledExecutorService)this.mockScheduler);){
            MatcherAssert.assertThat((Object)eventSource.getReadyState(), (Matcher)Matchers.is((Object)2));
        }
    }

    @Test
    void openEventSourceSendsRequestWithExpectedHeaders() {
        try (DefaultSseSource eventSource = new DefaultSseSource(this.configDontRetry, this.mockClient, (ScheduledExecutorService)this.mockScheduler);){
            CompletableFuture<HttpResponse> response = DefaultSseSourceTestCase.getOkResponse();
            Mockito.when((Object)this.mockClient.sendAsync((HttpRequest)ArgumentMatchers.any(), (HttpRequestOptions)ArgumentMatchers.any())).thenReturn(response);
            eventSource.open();
            ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
            ((HttpClient)Mockito.verify((Object)this.mockClient)).sendAsync((HttpRequest)requestCaptor.capture(), (HttpRequestOptions)ArgumentMatchers.any());
            HttpRequest initiatorRequest = (HttpRequest)requestCaptor.getValue();
            MatcherAssert.assertThat((Object)initiatorRequest.getMethod(), (Matcher)Matchers.is((Object)"GET"));
            MatcherAssert.assertThat((Object)initiatorRequest.getHeaderNames(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.equalToIgnoringCase((String)"Accept"), Matchers.equalToIgnoringCase((String)"Cache-Control")}));
            MatcherAssert.assertThat((Object)initiatorRequest.getHeaderValue("Accept"), (Matcher)Matchers.is((Object)"text/event-stream"));
            MatcherAssert.assertThat((Object)initiatorRequest.getHeaderValue("Cache-Control"), (Matcher)Matchers.is((Object)"no-cache"));
            MatcherAssert.assertThat((String)"Event source should be open", (Object)eventSource.getReadyState(), (Matcher)Matchers.is((Object)1));
        }
    }

    @Test
    void customRequestOptionsAreUsed() {
        try (DefaultSseSource eventSource = new DefaultSseSource(this.configDontRetry, this.mockClient, (ScheduledExecutorService)this.mockScheduler);){
            CompletableFuture<HttpResponse> response = DefaultSseSourceTestCase.getOkResponse();
            Mockito.when((Object)this.mockClient.sendAsync((HttpRequest)ArgumentMatchers.any(), (HttpRequestOptions)ArgumentMatchers.any())).thenReturn(response);
            eventSource.open();
            ArgumentCaptor optionsCaptor = ArgumentCaptor.forClass(HttpRequestOptions.class);
            ((HttpClient)Mockito.verify((Object)this.mockClient)).sendAsync((HttpRequest)ArgumentMatchers.any(), (HttpRequestOptions)optionsCaptor.capture());
            MatcherAssert.assertThat((Object)((HttpRequestOptions)optionsCaptor.getValue()), (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)this.mockOptions)));
        }
    }

    @Test
    void initiatorRequestCustomizerIsCalledAndTheBuilderAlreadyContainsBasicHeaders() {
        try (DefaultSseSource eventSource = new DefaultSseSource(this.configDontRetry, this.mockClient, (ScheduledExecutorService)this.mockScheduler);){
            CompletableFuture<HttpResponse> response = DefaultSseSourceTestCase.getOkResponse();
            Mockito.when((Object)this.mockClient.sendAsync((HttpRequest)ArgumentMatchers.any(), (HttpRequestOptions)ArgumentMatchers.any())).thenReturn(response);
            eventSource.open();
            ArgumentCaptor builderCaptor = ArgumentCaptor.forClass(HttpRequestBuilder.class);
            ((Consumer)Mockito.verify(this.mockCustomizer)).accept((HttpRequestBuilder)builderCaptor.capture());
            HttpRequest initiatorRequest = ((HttpRequestBuilder)builderCaptor.getValue()).build();
            MatcherAssert.assertThat((Object)initiatorRequest.getHeaderNames(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.equalToIgnoringCase((String)"Accept"), Matchers.equalToIgnoringCase((String)"Cache-Control")}));
            MatcherAssert.assertThat((Object)initiatorRequest.getHeaderValue("Accept"), (Matcher)Matchers.is((Object)"text/event-stream"));
            MatcherAssert.assertThat((Object)initiatorRequest.getHeaderValue("Cache-Control"), (Matcher)Matchers.is((Object)"no-cache"));
        }
    }

    @Test
    @Story(value="SSE Retry Mechanism")
    void whenAnExceptionHappensOnConnect_sourceSchedulesReconnection() {
        try (DefaultSseSource eventSource = new DefaultSseSource(this.configDontRetry, this.mockClient, (ScheduledExecutorService)this.mockScheduler);){
            CompletableFuture failure = CompletableFuture.failedFuture(new IOException("Connection reset (?)"));
            Mockito.when((Object)this.mockClient.sendAsync((HttpRequest)ArgumentMatchers.any(), (HttpRequestOptions)ArgumentMatchers.any())).thenReturn(failure);
            eventSource.open();
            MatcherAssert.assertThat((Object)eventSource.getReadyState(), (Matcher)Matchers.is((Object)0));
            ((Scheduler)Mockito.verify((Object)this.mockScheduler)).schedule((Runnable)ArgumentMatchers.any(Runnable.class), ((Long)ArgumentMatchers.eq((Object)SseRetryConfig.DEFAULT_RETRY_DELAY_MILLIS)).longValue(), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        }
    }

    @Test
    @Story(value="SSE Retry Mechanism")
    public void whenAnHttpErrorResponse_sourceSchedulesReconnection() {
        try (DefaultSseSource eventSource = new DefaultSseSource(this.configDontRetry, this.mockClient, (ScheduledExecutorService)this.mockScheduler);){
            CompletableFuture<HttpResponse> res = DefaultSseSourceTestCase.getErrorResponse(503);
            Mockito.when((Object)this.mockClient.sendAsync((HttpRequest)ArgumentMatchers.any(), (HttpRequestOptions)ArgumentMatchers.any())).thenReturn(res);
            eventSource.open();
            MatcherAssert.assertThat((Object)eventSource.getReadyState(), (Matcher)Matchers.is((Object)0));
            ((Scheduler)Mockito.verify((Object)this.mockScheduler)).schedule((Runnable)ArgumentMatchers.any(Runnable.class), ((Long)ArgumentMatchers.eq((Object)SseRetryConfig.DEFAULT_RETRY_DELAY_MILLIS)).longValue(), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        }
    }

    @Test
    public void whenASourceIsTriedToBeOpenedTwice_itOnlySendsOneRequest() {
        try (DefaultSseSource eventSource = new DefaultSseSource(this.configDontRetry, this.mockClient, (ScheduledExecutorService)this.mockScheduler);){
            CompletableFuture<HttpResponse> responseFuture = DefaultSseSourceTestCase.getOkResponse();
            Mockito.when((Object)this.mockClient.sendAsync((HttpRequest)ArgumentMatchers.any(), (HttpRequestOptions)ArgumentMatchers.any())).thenReturn(responseFuture);
            eventSource.open();
            eventSource.open();
            ((HttpClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)1))).sendAsync((HttpRequest)ArgumentMatchers.any(), (HttpRequestOptions)ArgumentMatchers.any());
        }
    }

    @Test
    public void routesEventsToRegisteredListeners() throws Throwable {
        try (DefaultSseSource eventSource = new DefaultSseSource(this.configDontRetry, this.mockClient, (ScheduledExecutorService)this.mockScheduler);){
            Runnable stream = this.mockEventStream("event: name1\ndata: message1\n\nevent: name2\ndata: message2\n\nevent: name2\ndata: message3\n\nevent: name1\ndata: message4\n\nevent: other\ndata: message5\n\nevent: yetAnother\ndata: message6\n\n");
            SSEEventsAggregator aggregatorForName1 = new SSEEventsAggregator();
            SSEEventsAggregator aggregatorForName2 = new SSEEventsAggregator();
            SSEEventsAggregator aggregatorForFallback = new SSEEventsAggregator();
            eventSource.register("name1", (SseListener)aggregatorForName1);
            eventSource.register("name2", (SseListener)aggregatorForName2);
            eventSource.register((SseListener)aggregatorForFallback);
            eventSource.open();
            stream.run();
            MatcherAssert.assertThat(aggregatorForName1.getList(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ServerSentEventTypeSafeMatcher.aServerSentEvent("name1", "message1"), ServerSentEventTypeSafeMatcher.aServerSentEvent("name1", "message4")}));
            MatcherAssert.assertThat(aggregatorForName2.getList(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ServerSentEventTypeSafeMatcher.aServerSentEvent("name2", "message2"), ServerSentEventTypeSafeMatcher.aServerSentEvent("name2", "message3")}));
            MatcherAssert.assertThat(aggregatorForFallback.getList(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ServerSentEventTypeSafeMatcher.aServerSentEvent("other", "message5"), ServerSentEventTypeSafeMatcher.aServerSentEvent("yetAnother", "message6")}));
        }
    }

    @Test
    @Issue(value="W-18085890")
    public void preservesHeaderCaseOnInitiatorRequest() {
        this.testPreserveHeaderCase(true);
    }

    @Test
    @Issue(value="W-18085890")
    public void doesNotPreservesHeaderCaseOnInitiatorRequest() {
        this.testPreserveHeaderCase(false);
    }

    private void testPreserveHeaderCase(boolean preserveHeaderCase) {
        SseSourceConfig config = SseSourceConfig.builder((String)TEST_URL).withPreserveHeadersCase(preserveHeaderCase).build();
        try (DefaultSseSource eventSource = new DefaultSseSource(config, this.mockClient, (ScheduledExecutorService)this.mockScheduler);){
            CompletableFuture<HttpResponse> response = DefaultSseSourceTestCase.getOkResponse();
            Mockito.when((Object)this.mockClient.sendAsync((HttpRequest)ArgumentMatchers.any(), (HttpRequestOptions)ArgumentMatchers.any())).thenReturn(response);
            eventSource.open();
            ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
            ((HttpClient)Mockito.verify((Object)this.mockClient)).sendAsync((HttpRequest)requestCaptor.capture(), (HttpRequestOptions)ArgumentMatchers.any());
            Collection headerNames = ((HttpRequest)requestCaptor.getValue()).getHeaderNames();
            if (preserveHeaderCase) {
                MatcherAssert.assertThat((Object)headerNames, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.equalTo((Object)"Accept"), Matchers.equalTo((Object)"Cache-Control")}));
            } else {
                MatcherAssert.assertThat((Object)headerNames, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.equalTo((Object)"Accept".toLowerCase()), Matchers.equalTo((Object)"Cache-Control".toLowerCase())}));
            }
        }
    }

    @Test
    @Story(value="SSE Retry Mechanism")
    public void stopRetriesOnCertainError() {
        try (DefaultSseSource eventSource = new DefaultSseSource(this.configDontRetry, this.mockClient, (ScheduledExecutorService)this.mockScheduler);){
            CompletableFuture failure = CompletableFuture.failedFuture(new IOException("Certain error"));
            Mockito.when((Object)this.mockClient.sendAsync((HttpRequest)ArgumentMatchers.any(), (HttpRequestOptions)ArgumentMatchers.any())).thenReturn(failure);
            eventSource.doOnConnectionFailure(ctx -> {
                if (null != ctx.error() && "Certain error".equals(ctx.error().getMessage())) {
                    ctx.stopRetrying();
                }
            });
            eventSource.open();
            MatcherAssert.assertThat((Object)eventSource.getReadyState(), (Matcher)Matchers.is((Object)2));
            ((Scheduler)Mockito.verify((Object)this.mockScheduler, (VerificationMode)Mockito.never())).schedule((Runnable)ArgumentMatchers.any(Runnable.class), ((Long)ArgumentMatchers.eq((Object)SseRetryConfig.DEFAULT_RETRY_DELAY_MILLIS)).longValue(), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        }
    }

    @Test
    @Story(value="SSE Retry Mechanism")
    public void stopRetriesOnResponse500() {
        try (DefaultSseSource eventSource = new DefaultSseSource(this.configDontRetry, this.mockClient, (ScheduledExecutorService)this.mockScheduler);){
            CompletableFuture<HttpResponse> response500 = DefaultSseSourceTestCase.getErrorResponse(500);
            Mockito.when((Object)this.mockClient.sendAsync((HttpRequest)ArgumentMatchers.any(), (HttpRequestOptions)ArgumentMatchers.any())).thenReturn(response500);
            eventSource.doOnConnectionFailure(ctx -> {
                if (null != ctx.response() && ctx.response().getStatusCode() == 500) {
                    ctx.stopRetrying();
                }
            });
            eventSource.open();
            MatcherAssert.assertThat((Object)eventSource.getReadyState(), (Matcher)Matchers.is((Object)2));
            ((Scheduler)Mockito.verify((Object)this.mockScheduler, (VerificationMode)Mockito.never())).schedule((Runnable)ArgumentMatchers.any(Runnable.class), ((Long)ArgumentMatchers.eq((Object)SseRetryConfig.DEFAULT_RETRY_DELAY_MILLIS)).longValue(), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        }
    }

    @Test
    @Story(value="SSE Retry Mechanism")
    public void shouldRetryOnStreamEnd() throws Throwable {
        try (DefaultSseSource eventSource = new DefaultSseSource(this.configWithRetry, this.mockClient, (ScheduledExecutorService)this.mockScheduler);){
            Runnable stream = this.mockEventStream("");
            eventSource.open();
            stream.run();
            MatcherAssert.assertThat((Object)eventSource.getReadyState(), (Matcher)Matchers.is((Object)0));
            ((Scheduler)Mockito.verify((Object)this.mockScheduler)).schedule((Runnable)ArgumentMatchers.any(Runnable.class), ((Long)ArgumentMatchers.eq((Object)SseRetryConfig.DEFAULT_RETRY_DELAY_MILLIS)).longValue(), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        }
    }

    @Test
    public void serverOverridesRetryTimeout() throws Throwable {
        Long newDelay = SseRetryConfig.DEFAULT_RETRY_DELAY_MILLIS + 100L;
        try (DefaultSseSource eventSource = new DefaultSseSource(this.configWithRetry, this.mockClient, (ScheduledExecutorService)this.mockScheduler);){
            Runnable stream = this.mockEventStream("event: name1\ndata: message1\nretry: %d\n\n".formatted(newDelay));
            eventSource.open();
            stream.run();
            ((Scheduler)Mockito.verify((Object)this.mockScheduler)).schedule((Runnable)ArgumentMatchers.any(Runnable.class), ((Long)ArgumentMatchers.eq((Object)newDelay)).longValue(), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        }
    }

    @Test
    void givenAClosedSource_itFailsWhenReceivesAnEvent() {
        SseListener mockListener = (SseListener)Mockito.mock(SseListener.class);
        DefaultSseSource eventSource = new DefaultSseSource(this.configWithRetry, this.mockClient, (ScheduledExecutorService)this.mockScheduler);
        eventSource.register(mockListener);
        Runnable stream = this.mockEventStream("event: name\ndata: message\n\n");
        eventSource.open();
        eventSource.close();
        IllegalStateException exception = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, stream::run);
        MatcherAssert.assertThat((Object)exception, (Matcher)ThrowableMessageMatcher.hasMessage((String)"HTTP Entity was closed from reader side"));
        ((SseListener)Mockito.verify((Object)mockListener, (VerificationMode)Mockito.never())).onEvent((ServerSentEvent)ArgumentMatchers.any(ServerSentEventImpl.class));
    }

    @Test
    public void sourceCanBeReopened() throws Throwable {
        SseListener mockListener = (SseListener)Mockito.mock(SseListener.class);
        DefaultSseSource eventSource = new DefaultSseSource(this.configWithRetry, this.mockClient, (ScheduledExecutorService)this.mockScheduler);
        eventSource.register(mockListener);
        this.mockEventStream("event: name\ndata: message\n\n");
        eventSource.open();
        eventSource.close();
        Runnable stream = this.mockEventStream("event: name\ndata: message\n\n");
        eventSource.open();
        stream.run();
        ((SseListener)Mockito.verify((Object)mockListener)).onEvent((ServerSentEvent)ArgumentMatchers.any(ServerSentEventImpl.class));
    }

    @Test
    void openSseSourceFromNonReactiveResponseSchedulesConsumption() {
        SseListener mockListener = (SseListener)Mockito.mock(SseListener.class);
        HttpResponse response = (HttpResponse)Mockito.mock(HttpResponse.class);
        Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
        Mockito.when((Object)response.getHeaderValue("Content-Type")).thenReturn((Object)"text/event-stream");
        Mockito.when((Object)response.getEntity()).thenReturn((Object)new EmptyHttpEntity());
        try (DefaultSseSource eventSource = new DefaultSseSource(SseSourceConfig.fromResponse((HttpResponse)response).build(), this.mockClient, (ScheduledExecutorService)this.mockScheduler);){
            eventSource.register(mockListener);
            eventSource.open();
        }
        ((Scheduler)Mockito.verify((Object)this.mockScheduler)).submit((Runnable)ArgumentMatchers.any(SseStreamConsumer.class));
    }

    @Test
    public void parseEventStreamWithASourceOpenedFromAResponse() throws ExecutionException, InterruptedException {
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        HttpResponse response = (HttpResponse)Mockito.mock(HttpResponse.class);
        Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
        Mockito.when((Object)response.getHeaderValue("Content-Type")).thenReturn((Object)"text/event-stream");
        Mockito.when((Object)response.getEntity()).thenReturn((Object)new StringHttpEntity("event: name\ndata: message\n\n"));
        SSEEventsAggregator listener = new SSEEventsAggregator();
        try (DefaultSseSource eventSource = new DefaultSseSource(SseSourceConfig.fromResponse((HttpResponse)response).build(), this.mockClient, executorService);){
            eventSource.register((SseListener)listener);
            eventSource.open();
            MatcherAssert.assertThat(listener.getList(), (Matcher)Matchers.contains(ServerSentEventTypeSafeMatcher.aServerSentEvent("name", "message")));
        }
    }

    @Test
    public void notAnSSEResponse() {
        SseListener mockListener = (SseListener)Mockito.mock(SseListener.class);
        HttpResponse response = (HttpResponse)Mockito.mock(HttpResponse.class);
        Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
        Mockito.when((Object)response.getHeaderValue("Content-Type")).thenReturn((Object)"application/json");
        try (DefaultSseSource eventSource = new DefaultSseSource(SseSourceConfig.fromResponse((HttpResponse)response).build(), this.mockClient, (ScheduledExecutorService)this.mockScheduler);){
            eventSource.register(mockListener);
            IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> ((DefaultSseSource)eventSource).open());
            MatcherAssert.assertThat((Object)exception, (Matcher)ThrowableMessageMatcher.hasMessage((String)"Response is not a successfully established SSE connection. Status code: '200', Content-Type: 'application/json'"));
        }
        ((Scheduler)Mockito.verify((Object)this.mockScheduler, (VerificationMode)Mockito.never())).submit((Runnable)ArgumentMatchers.any(SseStreamConsumer.class));
    }

    private Runnable mockEventStream(String eventStreamPayload) {
        NettyFeedableHttpEntity entity = new NettyFeedableHttpEntity((long)eventStreamPayload.length());
        CompletableFuture<HttpResponse> response = DefaultSseSourceTestCase.getOkResponse((HttpEntity)entity);
        Mockito.when((Object)this.mockClient.sendAsync((HttpRequest)ArgumentMatchers.any(), (HttpRequestOptions)ArgumentMatchers.any())).thenReturn(response);
        return () -> {
            try {
                entity.feed(StandardCharsets.UTF_8.encode(eventStreamPayload));
                entity.complete();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private static CompletableFuture<HttpResponse> getOkResponse() {
        return DefaultSseSourceTestCase.getOkResponse((HttpEntity)new EmptyHttpEntity());
    }

    private static CompletableFuture<HttpResponse> getOkResponse(HttpEntity entity) {
        HttpResponse response = (HttpResponse)Mockito.mock(HttpResponse.class);
        Mockito.when((Object)response.getStatusCode()).thenReturn((Object)200);
        Mockito.when((Object)response.getHeaderValue("Content-Type")).thenReturn((Object)"text/event-stream");
        Mockito.when((Object)response.getEntity()).thenReturn((Object)entity);
        return CompletableFuture.completedFuture(response);
    }

    private static CompletableFuture<HttpResponse> getErrorResponse(int statusCode) {
        HttpResponse response = (HttpResponse)Mockito.mock(HttpResponse.class);
        Mockito.when((Object)response.getStatusCode()).thenReturn((Object)statusCode);
        return CompletableFuture.completedFuture(response);
    }
}

