/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.context.notification;

import java.io.Serializable;

public final class FlowStackElement
implements Serializable {
    private static final long serialVersionUID = 192333659386101806L;
    private final String flowName;
    private final String processorPath;
    private final Long creationTime;

    public FlowStackElement(String flowName, String processorPath) {
        this.flowName = flowName;
        this.processorPath = processorPath;
        this.creationTime = System.currentTimeMillis();
    }

    public String getProcessorPath() {
        return this.processorPath;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public Long getCreationTime() {
        return this.creationTime;
    }

    public Long getElapsedTime() {
        return System.currentTimeMillis() - this.creationTime;
    }

    public String toString() {
        if (this.processorPath == null) {
            return String.format("%s %d ms", this.flowName, this.getElapsedTime());
        }
        return String.format("%s(%s) %d ms", this.flowName, this.processorPath, this.getElapsedTime());
    }
}

