/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import java.time.Duration;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.LongUnaryOperator;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.processor.chain.InterceptedReactiveProcessor;
import org.mule.runtime.core.internal.processor.strategy.AbstractProcessingStrategy;
import org.mule.runtime.core.internal.processor.strategy.AbstractReactorStreamProcessingStrategy;
import org.mule.runtime.core.internal.processor.strategy.AbstractStreamProcessingStrategyFactory;
import org.mule.runtime.core.internal.util.rx.RejectionCallbackExecutorServiceDecorator;
import org.mule.runtime.core.internal.util.rx.RetrySchedulerWrapper;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class ProactorStreamProcessingStrategy
extends AbstractReactorStreamProcessingStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProactorStreamProcessingStrategy.class);
    private static final long SCHEDULER_BUSY_RETRY_INTERVAL_NS = TimeUnit.MILLISECONDS.toNanos(2L);
    private static Class<ClassLoader> sdkOperationClass;
    private final Supplier<Scheduler> blockingSchedulerSupplier;
    private final Supplier<Scheduler> cpuIntensiveSchedulerSupplier;
    private Scheduler blockingScheduler;
    private Scheduler cpuIntensiveScheduler;
    protected final AtomicLong lastRetryTimestamp = new AtomicLong(Long.MIN_VALUE);
    private final AtomicInteger inFlightEvents = new AtomicInteger();
    private final AtomicInteger queuedEvents = new AtomicInteger();
    private final BiConsumer<CoreEvent, Throwable> IN_FLIGHT_DECREMENT_CALLBACK = (e, t) -> this.inFlightEvents.decrementAndGet();
    private final BiConsumer<CoreEvent, Throwable> QUEUED_DECREMENT_CALLBACK = (e, t) -> this.queuedEvents.decrementAndGet();
    private final LongUnaryOperator LAST_RETRY_TIMESTAMP_CHECK_OPERATOR = v -> System.nanoTime() - v < SCHEDULER_BUSY_RETRY_INTERVAL_NS * 2L ? v : Long.MIN_VALUE;

    public ProactorStreamProcessingStrategy(int subscriberCount, Supplier<Scheduler> cpuLightSchedulerSupplier, Supplier<Scheduler> blockingSchedulerSupplier, Supplier<Scheduler> cpuIntensiveSchedulerSupplier, int parallelism, int maxConcurrency, boolean maxConcurrencyEagerCheck) {
        super(subscriberCount, cpuLightSchedulerSupplier, parallelism, maxConcurrency, maxConcurrencyEagerCheck);
        this.blockingSchedulerSupplier = blockingSchedulerSupplier;
        this.cpuIntensiveSchedulerSupplier = cpuIntensiveSchedulerSupplier;
    }

    @Override
    public void start() throws MuleException {
        super.start();
        this.blockingScheduler = this.blockingSchedulerSupplier.get();
        this.cpuIntensiveScheduler = this.cpuIntensiveSchedulerSupplier.get();
    }

    @Override
    protected Scheduler createCpuLightScheduler(Supplier<Scheduler> cpuLightSchedulerSupplier) {
        return new RetrySchedulerWrapper(super.createCpuLightScheduler(cpuLightSchedulerSupplier), 2L);
    }

    @Override
    public void stop() throws MuleException {
        if (this.blockingScheduler != null) {
            this.blockingScheduler.stop();
        }
        if (this.cpuIntensiveScheduler != null) {
            this.cpuIntensiveScheduler.stop();
        }
        super.stop();
    }

    @Override
    public ReactiveProcessor onProcessor(ReactiveProcessor processor) {
        if (processor.getProcessingType() == ReactiveProcessor.ProcessingType.BLOCKING || processor.getProcessingType() == ReactiveProcessor.ProcessingType.IO_RW) {
            return this.proactor(processor, (ScheduledExecutorService)this.blockingScheduler);
        }
        if (processor.getProcessingType() == ReactiveProcessor.ProcessingType.CPU_INTENSIVE) {
            return this.proactor(processor, (ScheduledExecutorService)this.cpuIntensiveScheduler);
        }
        return super.onProcessor(processor);
    }

    protected ReactiveProcessor proactor(ReactiveProcessor processor, ScheduledExecutorService scheduler) {
        LOGGER.debug("Doing proactor() for {} on {}. maxConcurrency={}, parallelism={}, subscribers={}", new Object[]{processor, scheduler, this.maxConcurrency, this.getParallelism(), this.subscribers});
        RejectionCallbackExecutorServiceDecorator retryScheduler = new RejectionCallbackExecutorServiceDecorator(scheduler, this.decorateScheduler((ScheduledExecutorService)this.getCpuLightScheduler()), () -> this.onRejected(scheduler), () -> this.lastRetryTimestamp.set(Long.MIN_VALUE), Duration.ofMillis(2L));
        if (this.maxConcurrency == 1) {
            return publisher -> this.scheduleProcessor(processor, retryScheduler, (Flux<CoreEvent>)Flux.from((Publisher)publisher)).subscriberContext(ctx -> ctx.put((Object)"mule.nb.processorScheduler", (Object)scheduler));
        }
        if (this.maxConcurrency == Integer.MAX_VALUE) {
            if (processor.getProcessingType() == ReactiveProcessor.ProcessingType.CPU_INTENSIVE && processor instanceof InterceptedReactiveProcessor && sdkOperationClass != null && sdkOperationClass.isAssignableFrom(((InterceptedReactiveProcessor)processor).getProcessor().getClass())) {
                return publisher -> this.scheduleProcessor(processor, retryScheduler, (Flux<CoreEvent>)Flux.from((Publisher)publisher)).subscriberContext(ctx -> ctx.put((Object)"mule.nb.processorScheduler", (Object)scheduler));
            }
            return publisher -> Flux.from((Publisher)publisher).flatMap(event -> this.scheduleProcessor(processor, retryScheduler, (Mono<CoreEvent>)Mono.just((Object)event)).subscriberContext(ctx -> ctx.put((Object)"mule.nb.processorScheduler", (Object)scheduler)), Integer.MAX_VALUE);
        }
        return publisher -> Flux.from((Publisher)publisher).flatMap(event -> this.scheduleProcessor(processor, retryScheduler, (Mono<CoreEvent>)Mono.just((Object)event)).subscriberContext(ctx -> ctx.put((Object)"mule.nb.processorScheduler", (Object)scheduler)), Math.max(this.maxConcurrency / (this.getParallelism() * this.subscribers), 1));
    }

    private void onRejected(ScheduledExecutorService scheduler) {
        LOGGER.trace("Shared scheduler {} is busy. Scheduling of the current event will be retried after {}ms.", (Object)(scheduler instanceof Scheduler ? ((Scheduler)scheduler).getName() : scheduler.toString()), (Object)2L);
        this.lastRetryTimestamp.set(System.nanoTime());
    }

    protected abstract Mono<CoreEvent> scheduleProcessor(ReactiveProcessor var1, ScheduledExecutorService var2, Mono<CoreEvent> var3);

    protected abstract Flux<CoreEvent> scheduleProcessor(ReactiveProcessor var1, ScheduledExecutorService var2, Flux<CoreEvent> var3);

    protected Scheduler getBlockingScheduler() {
        return this.blockingScheduler;
    }

    protected Scheduler getCpuIntensiveScheduler() {
        return this.cpuIntensiveScheduler;
    }

    private boolean checkCapacity(CoreEvent event) {
        if (this.lastRetryTimestamp.get() != Long.MIN_VALUE && this.lastRetryTimestamp.updateAndGet(this.LAST_RETRY_TIMESTAMP_CHECK_OPERATOR) != Long.MIN_VALUE) {
            if (!this.maxConcurrencyEagerCheck) {
                if (this.queuedEvents.incrementAndGet() > this.getBufferQueueSize()) {
                    this.queuedEvents.decrementAndGet();
                    return false;
                }
                ((BaseEventContext)event.getContext()).onResponse(this.QUEUED_DECREMENT_CALLBACK);
            } else {
                return false;
            }
        }
        if (this.maxConcurrencyEagerCheck) {
            if (this.inFlightEvents.incrementAndGet() > this.maxConcurrency) {
                this.inFlightEvents.decrementAndGet();
                return false;
            }
            ((BaseEventContext)event.getContext()).onResponse(this.IN_FLIGHT_DECREMENT_CALLBACK);
        }
        return true;
    }

    protected int getBufferQueueSize() {
        return AbstractStreamProcessingStrategyFactory.DEFAULT_BUFFER_SIZE;
    }

    @Override
    public void checkBackpressureAccepting(CoreEvent event) throws RejectedExecutionException {
        if (!this.checkCapacity(event)) {
            throw new RejectedExecutionException();
        }
    }

    @Override
    public boolean checkBackpressureEmitting(CoreEvent event) {
        return this.checkCapacity(event);
    }

    static {
        try {
            sdkOperationClass = ProactorStreamProcessingStrategy.class.getClassLoader().loadClass("org.mule.runtime.module.extension.internal.runtime.operation.OperationMessageProcessor");
        }
        catch (ClassNotFoundException e) {
            LOGGER.debug("OperationMessageProcessor interface not available in current context", (Throwable)e);
        }
    }

    protected final class ProactorSinkWrapper<E>
    implements AbstractProcessingStrategy.ReactorSink<E> {
        private final AbstractProcessingStrategy.ReactorSink<E> innerSink;

        protected ProactorSinkWrapper(AbstractProcessingStrategy.ReactorSink<E> innerSink) {
            this.innerSink = innerSink;
        }

        @Override
        public final void accept(CoreEvent event) {
            this.innerSink.accept(event);
        }

        @Override
        public final boolean emit(CoreEvent event) {
            return this.innerSink.emit(event);
        }

        @Override
        public E intoSink(CoreEvent event) {
            return this.innerSink.intoSink(event);
        }

        public final void dispose() {
            this.innerSink.dispose();
        }
    }
}

