/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.routing.AbstractForkJoinRouter;
import org.mule.runtime.core.internal.routing.FirstSuccessfulRoutingStrategy;
import org.mule.runtime.core.internal.routing.ForkJoinStrategy;
import org.mule.runtime.core.internal.routing.ForkJoinStrategyFactory;
import org.mule.runtime.core.internal.routing.forkjoin.CollectMapForkJoinStrategyFactory;
import org.mule.runtime.core.privileged.processor.Router;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class ScatterGatherRouter
extends AbstractForkJoinRouter
implements Router {
    private List<MessageProcessorChain> routes = Collections.emptyList();
    @Inject
    ConfigurationProperties configurationProperties;

    @Override
    protected Consumer<CoreEvent> onEvent() {
        return event -> FirstSuccessfulRoutingStrategy.validateMessageIsNotConsumable(event.getMessage());
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        if (this.routes.size() < 2 && !this.isLazyInit()) {
            throw new InitialisationException(CoreMessages.noEndpointsForRouter(), null);
        }
    }

    @Override
    protected Publisher<ForkJoinStrategy.RoutingPair> getRoutingPairs(CoreEvent event) {
        return Flux.fromIterable(this.routes).map(route -> ForkJoinStrategy.RoutingPair.of(event, route));
    }

    @Override
    protected List<MessageProcessorChain> getOwnedObjects() {
        return this.routes;
    }

    public void setRoutes(List<MessageProcessorChain> routes) {
        Preconditions.checkArgument((routes.size() > 1 || this.isLazyInit() ? 1 : 0) != 0, (String)"At least 2 routes are required for ScatterGather");
        this.routes = routes;
    }

    @Override
    protected boolean isDelayErrors() {
        return true;
    }

    @Override
    protected int getDefaultMaxConcurrency() {
        return this.routes.size();
    }

    @Override
    protected ForkJoinStrategyFactory getDefaultForkJoinStrategyFactory() {
        return new CollectMapForkJoinStrategyFactory();
    }

    private boolean isLazyInit() {
        return this.configurationProperties.resolveBooleanProperty("mule.application.deployment.lazyInit").orElse(false);
    }
}

