/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming;

import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.runtime.api.streaming.Cursor;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.core.internal.streaming.MutableStreamingStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CursorProviderJanitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CursorProviderJanitor.class);
    CursorProvider provider;
    private final Set<Cursor> cursors;
    private final MutableStreamingStatistics statistics;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean released = new AtomicBoolean(false);

    public CursorProviderJanitor(CursorProvider provider, Set<Cursor> cursors, MutableStreamingStatistics statistics) {
        this.provider = provider;
        this.cursors = cursors;
        this.statistics = statistics;
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.provider.close();
            }
            finally {
                this.statistics.decrementOpenProviders();
            }
        }
    }

    public final void releaseResources() {
        if (!this.released.compareAndSet(false, true)) {
            return;
        }
        try {
            this.close();
        }
        catch (Exception e) {
            LOGGER.warn("Exception was found trying to close CursorProvider. Will try to release its resources anyway", (Throwable)e);
        }
        try {
            this.cursors.forEach(this::cleanUpCursor);
        }
        finally {
            this.provider.releaseResources();
            this.cursors.clear();
            this.provider = null;
        }
    }

    public void releaseCursor(Cursor cursor) {
        if (this.cursors.remove(cursor)) {
            this.cleanUpCursor(cursor);
        }
    }

    private void cleanUpCursor(Cursor cursor) {
        try {
            this.statistics.decrementOpenCursors();
            cursor.release();
            if (this.provider.isClosed() && this.cursors.isEmpty()) {
                this.releaseResources();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Exception was found trying to release cursor resources. Execution will continue", (Throwable)e);
        }
    }
}

