/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.api.streaming.Cursor;
import org.mule.runtime.core.internal.streaming.CursorProviderDecorator;
import org.mule.runtime.core.internal.streaming.CursorProviderJanitor;
import org.mule.runtime.core.internal.streaming.IdentifiableCursorProvider;
import org.mule.runtime.core.internal.streaming.MutableStreamingStatistics;

public abstract class ManagedCursorProvider<T extends Cursor>
extends CursorProviderDecorator<T>
implements IdentifiableCursorProvider<T> {
    private final Set<Cursor> cursors = Collections.newSetFromMap(new ConcurrentHashMap());
    private final MutableStreamingStatistics statistics;
    private final CursorProviderJanitor janitor;
    private final int id;

    protected ManagedCursorProvider(IdentifiableCursorProvider<T> delegate, MutableStreamingStatistics statistics) {
        super(delegate);
        this.id = delegate.getId();
        this.janitor = new CursorProviderJanitor(delegate, this.cursors, statistics);
        this.statistics = statistics;
        statistics.incrementOpenProviders();
    }

    @Override
    public final T openCursor() {
        Cursor cursor = this.delegate.openCursor();
        Cursor managedCursor = this.managedCursor(cursor);
        this.cursors.add(cursor);
        this.statistics.incrementOpenCursors();
        return (T)managedCursor;
    }

    protected abstract T managedCursor(T var1);

    @Override
    public final void releaseResources() {
        this.janitor.releaseResources();
    }

    @Override
    public int getId() {
        return this.id;
    }

    public CursorProviderJanitor getJanitor() {
        return this.janitor;
    }

    @Override
    public void close() {
        this.janitor.close();
    }
}

