/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.SystemUtils;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.core.internal.util.VersionRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdkVersionUtils {
    public static final String JAVA_VERSION_PROPERTY = "java.version";
    private static final String MULE_JDK_DEBUG = "mule.jdkDebug";
    private static final Logger logger = LoggerFactory.getLogger(JdkVersionUtils.class);
    public static final Pattern JDK_VERSION = Pattern.compile("^([0-9]+)(?:\\.([0-9]+))?(?:\\.([0-9]+))?(?:_([0-9]+))?(?:-?(.+))?$");

    public static List<JdkVersionRange> createJdkVersionRanges(String versionsString) {
        Matcher m = VersionRange.VERSION_RANGES.matcher(versionsString);
        if (!m.find()) {
            throw new IllegalArgumentException("Version range doesn't match pattern: " + VersionRange.VERSION_RANGES.pattern());
        }
        ArrayList<JdkVersionRange> versions = new ArrayList<JdkVersionRange>();
        do {
            versions.add(new JdkVersionRange(m.group(1)));
        } while (m.find());
        return versions;
    }

    public static JdkVersion getJdkVersion() {
        return new JdkVersion(System.getProperty(JAVA_VERSION_PROPERTY));
    }

    public static String getSupportedJdks() {
        return MuleManifest.getSupportedJdks();
    }

    public static boolean isSupportedJdkVendor() {
        return org.mule.runtime.core.api.util.SystemUtils.isSunJDK() || org.mule.runtime.core.api.util.SystemUtils.isAdoptOpenJDK() || org.mule.runtime.core.api.util.SystemUtils.isOpenJDK() || org.mule.runtime.core.api.util.SystemUtils.isAmazonJDK() || org.mule.runtime.core.api.util.SystemUtils.isAzulJDK() || org.mule.runtime.core.api.util.SystemUtils.isAppleJDK() || org.mule.runtime.core.api.util.SystemUtils.isIbmJDK();
    }

    public static String getRecommendedJdks() {
        return MuleManifest.getRecommndedJdks();
    }

    public static boolean isSupportedJdkVersion() {
        boolean isSupported = true;
        String supportedJdks = JdkVersionUtils.getSupportedJdks();
        if (supportedJdks != null && !supportedJdks.isEmpty()) {
            List<JdkVersionRange> supportedJdkVersionRanges = JdkVersionUtils.createJdkVersionRanges(supportedJdks);
            isSupported = JdkVersionUtils.isJdkInRange(JdkVersionUtils.getJdkVersion(), supportedJdkVersionRanges);
        }
        return isSupported;
    }

    public static boolean isRecommendedJdkVersion() {
        boolean isRecommended = true;
        String recommendedJdks = JdkVersionUtils.getRecommendedJdks();
        if (recommendedJdks != null && !recommendedJdks.isEmpty()) {
            List<JdkVersionRange> recommendedJdkVersionRanges = JdkVersionUtils.createJdkVersionRanges(recommendedJdks);
            isRecommended = JdkVersionUtils.isJdkInRange(JdkVersionUtils.getJdkVersion(), recommendedJdkVersionRanges);
        }
        return isRecommended;
    }

    private static boolean isJdkInRange(JdkVersion version, List<JdkVersionRange> ranges) {
        for (JdkVersionRange versionRange : ranges) {
            if (!versionRange.contains(version)) continue;
            return true;
        }
        return false;
    }

    private static boolean isJdkAboveRange(JdkVersion version, List<JdkVersionRange> ranges) {
        boolean isHigher = true;
        for (JdkVersionRange versionRange : ranges) {
            isHigher = isHigher && versionRange.isUnder(version);
        }
        return isHigher;
    }

    public static void validateJdk() throws RuntimeException {
        if (!JdkVersionUtils.isSupportedJdkVersion()) {
            if (JdkVersionUtils.isJdkAboveRange(JdkVersionUtils.getJdkVersion(), JdkVersionUtils.createJdkVersionRanges(JdkVersionUtils.getSupportedJdks()))) {
                logger.warn("We are looking into adding support for this JDK version. Use it at your own risk.");
            } else {
                throw new RuntimeException("Unsupported Jdk");
            }
        }
        if (!JdkVersionUtils.isSupportedJdkVendor()) {
            logger.info("You're executing with a JDK made by a vendor that is not on the recommended list of vendors. Vendor: " + SystemUtils.JAVA_VENDOR + " Please consider changing to a recommended JDK vendor.");
        } else if (Boolean.getBoolean(MULE_JDK_DEBUG)) {
            logger.info("You're executing with a JDK made by a recommended vendor.");
        }
    }

    public static class JdkVersionRange
    extends VersionRange {
        private JdkVersion lower;
        private JdkVersion upper;

        public JdkVersionRange(String versionRange) {
            super(versionRange);
            if (!this.getLowerVersion().isEmpty()) {
                this.lower = new JdkVersion(this.getLowerVersion());
            }
            if (!this.getUpperVersion().isEmpty()) {
                this.upper = new JdkVersion(this.getUpperVersion());
            }
        }

        public boolean contains(JdkVersion jdkVersion) {
            return (this.lower == null || jdkVersion.compareTo(this.lower) > 0 || jdkVersion.compareTo(this.lower) == 0 && this.isLowerBoundInclusive()) && (this.upper == null || jdkVersion.compareTo(this.upper) < 0 || jdkVersion.compareTo(this.upper) == 0 && this.isUpperBoundInclusive());
        }

        public boolean isUnder(JdkVersion jdkVersion) {
            return this.upper != null && (jdkVersion.compareTo(this.upper) > 0 || jdkVersion.compareTo(this.upper) == 0 && !this.isUpperBoundInclusive());
        }
    }

    public static class JdkVersion
    implements Comparable<JdkVersion> {
        private Integer major;
        private Integer minor;
        private Integer micro;
        private Integer update;
        private String milestone;

        public JdkVersion(String jdkVersionStr) {
            Matcher m = JDK_VERSION.matcher(jdkVersionStr);
            if (m.matches()) {
                int numGroups = m.groupCount();
                if (numGroups >= 1 && m.group(1) != null && !m.group(1).isEmpty()) {
                    this.major = Integer.parseInt(m.group(1));
                }
                if (numGroups >= 2 && m.group(2) != null && !m.group(2).isEmpty()) {
                    this.minor = Integer.parseInt(m.group(2));
                }
                if (numGroups >= 3 && m.group(3) != null && !m.group(3).isEmpty()) {
                    this.micro = Integer.parseInt(m.group(3));
                }
                if (numGroups >= 4 && m.group(4) != null && !m.group(4).isEmpty()) {
                    this.update = Integer.parseInt(m.group(4));
                }
                if (numGroups >= 5 && m.group(5) != null && !m.group(5).isEmpty()) {
                    this.milestone = m.group(5);
                }
            }
        }

        public Integer getMajor() {
            return this.major;
        }

        public Integer getMicro() {
            return this.micro;
        }

        public String getMilestone() {
            return this.milestone;
        }

        public Integer getMinor() {
            return this.minor;
        }

        public Integer getUpdate() {
            return this.update;
        }

        @Override
        public int compareTo(JdkVersion other) {
            int comparison = this.comparePointVersion(this.getMajor(), other.getMajor());
            if (comparison == 0 && (comparison = this.comparePointVersion(this.getMinor(), other.getMinor())) == 0 && (comparison = this.comparePointVersion(this.getMicro(), other.getMicro())) == 0 && (comparison = this.comparePointVersion(this.getUpdate(), other.getUpdate())) == 0) {
                comparison = this.comparePointVersion(this.getMilestone(), other.getMilestone());
            }
            return comparison;
        }

        private <T extends Comparable<T>> int comparePointVersion(T first, T second) {
            if (first != null && second != null) {
                return first.compareTo(second);
            }
            if (first != null) {
                return 1;
            }
            if (second != null) {
                return -1;
            }
            return 0;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.major == null ? 0 : this.major.hashCode());
            result = 31 * result + (this.micro == null ? 0 : this.micro.hashCode());
            result = 31 * result + (this.milestone == null ? 0 : this.milestone.hashCode());
            result = 31 * result + (this.minor == null ? 0 : this.minor.hashCode());
            result = 31 * result + (this.update == null ? 0 : this.update.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof JdkVersion)) {
                return false;
            }
            JdkVersion other = (JdkVersion)obj;
            if (this.major == null ? other.major != null : !this.major.equals(other.major)) {
                return false;
            }
            if (this.micro == null ? other.micro != null : !this.micro.equals(other.micro)) {
                return false;
            }
            if (this.milestone == null ? other.milestone != null : !this.milestone.equals(other.milestone)) {
                return false;
            }
            if (this.minor == null ? other.minor != null : !this.minor.equals(other.minor)) {
                return false;
            }
            return !(this.update == null ? other.update != null : !this.update.equals(other.update));
        }
    }
}

