/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.artifact;

import java.util.List;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.deployment.model.api.DeployableArtifact;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPlugin;
import org.mule.runtime.module.deployment.impl.internal.policy.ArtifactExtensionManagerFactory;
import org.mule.runtime.module.deployment.impl.internal.policy.CompositeArtifactExtensionManager;
import org.mule.runtime.module.extension.api.manager.ExtensionManagerFactory;
import org.mule.runtime.module.extension.internal.loader.ExtensionModelLoaderRepository;

public class CompositeArtifactExtensionManagerFactory
extends ArtifactExtensionManagerFactory {
    private final DeployableArtifact parentArtifact;

    public CompositeArtifactExtensionManagerFactory(DeployableArtifact parentArtifact, ExtensionModelLoaderRepository extensionModelLoaderRepository, List<ArtifactPlugin> artifactPlugins, ExtensionManagerFactory extensionManagerFactory) {
        super(artifactPlugins, extensionModelLoaderRepository, extensionManagerFactory);
        Preconditions.checkArgument((parentArtifact != null ? 1 : 0) != 0, (String)"application cannot be null");
        this.parentArtifact = parentArtifact;
    }

    @Override
    public ExtensionManager create(MuleContext muleContext) {
        ExtensionManager parentExtensionManager = (ExtensionManager)this.parentArtifact.getRegistry().lookupByName("_muleExtensionManager").get();
        ExtensionManager extensionManager = super.create(muleContext, parentExtensionManager.getExtensions());
        return new CompositeArtifactExtensionManager(parentExtensionManager, extensionManager);
    }
}

