/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.artifact.classloader;

import java.beans.Introspector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.ResourceBundle;
import org.mule.module.artifact.classloader.ThreadGroupContextClassLoaderSoftReferenceBuster;
import org.mule.runtime.module.artifact.api.classloader.ResourceReleaser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassLoaderResourceReleaser
implements ResourceReleaser {
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile ClassLoader classLoader;

    public ClassLoaderResourceReleaser(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void release() {
        this.shutdownAwsIdleConnectionReaperThread();
        this.cleanUpResourceBundle();
        this.clearClassLoaderSoftkeys();
    }

    private void cleanUpResourceBundle() {
        try {
            ResourceBundle.clearCache(this.classLoader);
        }
        catch (Exception e) {
            this.logger.warn("Couldn't clean up ResourceBundle. This can cause a memory leak.", (Throwable)e);
        }
    }

    private void clearClassLoaderSoftkeys() {
        try {
            Introspector.flushCaches();
            ThreadGroupContextClassLoaderSoftReferenceBuster.bustSoftReferences(this.classLoader);
            System.gc();
        }
        catch (Exception e) {
            this.logger.warn("Couldn't clear soft keys in caches. This can cause a classloader memory leak.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownAwsIdleConnectionReaperThread() {
        try {
            Class<?> idleConnectionReaperClass = this.classLoader.loadClass("com.amazonaws.http.IdleConnectionReaper");
            try {
                Method registeredManagersMethod = idleConnectionReaperClass.getMethod("getRegisteredConnectionManagers", new Class[0]);
                List httpClientConnectionManagers = (List)registeredManagersMethod.invoke(null, new Object[0]);
                if (httpClientConnectionManagers.isEmpty()) {
                    return;
                }
                Class<?> httpClientConnectionManagerClass = this.classLoader.loadClass("org.apache.http.conn.HttpClientConnectionManager");
                Method removeConnectionManager = idleConnectionReaperClass.getMethod("removeConnectionManager", httpClientConnectionManagerClass);
                for (Object connectionManager : httpClientConnectionManagers) {
                    boolean removed = (Boolean)removeConnectionManager.invoke(null, connectionManager);
                    if (removed || !this.logger.isDebugEnabled()) continue;
                    this.logger.debug(String.format("Unable to unregister HttpClientConnectionManager instance [%s] associated to AWS's IdleConnectionReaperThread", connectionManager));
                }
            }
            finally {
                Method shutdown = idleConnectionReaperClass.getMethod("shutdown", new Class[0]);
                shutdown.invoke(null, new Object[0]);
            }
        }
        catch (ClassNotFoundException | IllegalArgumentException | NoSuchMethodException shutdown) {
        }
        catch (IllegalAccessException | SecurityException | InvocationTargetException e) {
            this.logger.warn("Unable to shutdown AWS's IdleConnectionReaperThread, an error occurred: " + e.getMessage(), (Throwable)e);
        }
    }
}

