/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.retry.async;

import java.util.Map;
import java.util.concurrent.Executor;
import javax.inject.Inject;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.retry.RetryCallback;
import org.mule.runtime.core.api.retry.RetryContext;
import org.mule.runtime.core.api.retry.RetryNotifier;
import org.mule.runtime.core.api.retry.policy.RetryPolicy;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.internal.retry.async.FutureRetryContext;
import org.mule.runtime.core.internal.retry.async.RetryWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsynchronousRetryTemplate
extends AbstractComponent
implements RetryPolicyTemplate,
Initialisable,
Startable,
Stoppable,
Disposable {
    private final RetryPolicyTemplate delegate;
    private Latch startLatch;
    @Inject
    private MuleContext muleContext;
    private static final Logger LOGGER = LoggerFactory.getLogger(AsynchronousRetryTemplate.class);

    public AsynchronousRetryTemplate(RetryPolicyTemplate delegate) {
        this.delegate = delegate;
    }

    @Override
    public RetryContext execute(RetryCallback callback, Executor workManager) throws Exception {
        if (workManager == null) {
            throw new IllegalStateException("Cannot schedule a work till the workManager is initialized. Probably the connector hasn't been initialized yet");
        }
        RetryWorker worker = new RetryWorker(this.delegate, callback, workManager, this.startLatch);
        FutureRetryContext context = worker.getRetryContext();
        workManager.execute(worker);
        return context;
    }

    @Override
    public RetryPolicy createRetryInstance() {
        return this.delegate.createRetryInstance();
    }

    @Override
    public RetryNotifier getNotifier() {
        return this.delegate.getNotifier();
    }

    @Override
    public void setNotifier(RetryNotifier retryNotifier) {
        this.delegate.setNotifier(retryNotifier);
    }

    @Override
    public Map<Object, Object> getMetaInfo() {
        return this.delegate.getMetaInfo();
    }

    @Override
    public void setMetaInfo(Map<Object, Object> metaInfo) {
        this.delegate.setMetaInfo(metaInfo);
    }

    public RetryPolicyTemplate getDelegate() {
        return this.delegate;
    }

    public void setStartLatch(Latch latch) {
        this.startLatch = latch;
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.delegate, this.muleContext);
    }

    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.delegate);
    }

    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.delegate);
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.delegate, LOGGER);
    }

    @Override
    public boolean isAsync() {
        return true;
    }
}

