/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.util.CaseInsensitiveMapWrapper;

@NoExtend
public class CaseInsensitiveHashMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = -7074633917369299456L;
    private static final CaseInsensitiveHashMap EMPTY_MAP = new CaseInsensitiveHashMap().toImmutableCaseInsensitiveMap();
    protected Map<K, V> delegate = new CaseInsensitiveMapWrapper();

    public static <K, V> CaseInsensitiveHashMap<K, V> emptyCaseInsensitiveMap() {
        return EMPTY_MAP;
    }

    public CaseInsensitiveHashMap() {
    }

    public CaseInsensitiveHashMap(Map map) {
        this.delegate.putAll(map);
    }

    public Object clone() {
        return new CaseInsensitiveHashMap<K, V>(this.delegate);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.delegate.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.delegate.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> values) {
        this.delegate.putAll(values);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public CaseInsensitiveHashMap<K, V> toImmutableCaseInsensitiveMap() {
        if (this instanceof ImmutableCaseInsensitiveHashMap) {
            return this;
        }
        return new ImmutableCaseInsensitiveHashMap(this);
    }

    private static class ImmutableCaseInsensitiveHashMap<K, V>
    extends CaseInsensitiveHashMap<K, V> {
        private ImmutableCaseInsensitiveHashMap(CaseInsensitiveHashMap<K, V> caseInsensitiveHashMap) {
            super(caseInsensitiveHashMap);
            this.delegate = Collections.unmodifiableMap(this.delegate);
        }
    }
}

