/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.context.notification;

import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.spi.LoggerContext;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.notification.EnrichedNotificationInfo;
import org.mule.runtime.api.notification.MessageProcessorNotification;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.PipelineMessageNotification;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.context.notification.FlowStackElement;
import org.mule.runtime.core.api.context.notification.FlowTraceManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.context.notification.DefaultFlowCallStack;
import org.mule.runtime.core.internal.context.notification.DefaultProcessorsTrace;
import org.mule.runtime.core.internal.context.notification.FlowNotificationTextDebugger;
import org.mule.runtime.core.internal.context.notification.MessageProcessorTextDebugger;
import org.mule.runtime.core.internal.logging.LogConfigChangeSubject;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.execution.LocationExecutionContextProvider;

public class MessageProcessingFlowTraceManager
extends LocationExecutionContextProvider
implements FlowTraceManager,
MuleContextAware,
Initialisable,
Disposable {
    public static final String FLOW_STACK_INFO_KEY = "FlowStack";
    private final FlowNotificationTextDebugger pipelineProcessorDebugger;
    private final MessageProcessorTextDebugger messageProcessorTextDebugger;
    private MuleContext muleContext;
    private volatile boolean listenersAdded = false;
    private PropertyChangeListener logConfigChangeListener = evt -> this.handleNotificationListeners();

    public MessageProcessingFlowTraceManager() {
        this.messageProcessorTextDebugger = new MessageProcessorTextDebugger(this);
        this.pipelineProcessorDebugger = new FlowNotificationTextDebugger(this);
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void initialise() throws InitialisationException {
        LoggerContext context = LogManager.getContext((boolean)false);
        if (context != null && context instanceof LogConfigChangeSubject) {
            ((LogConfigChangeSubject)context).registerLogConfigChangeListener(this.logConfigChangeListener);
        }
        this.handleNotificationListeners();
    }

    public void dispose() {
        LoggerContext context = LogManager.getContext((boolean)false);
        if (context != null && context instanceof LogConfigChangeSubject) {
            ((LogConfigChangeSubject)context).unregisterLogConfigChangeListener(this.logConfigChangeListener);
        }
        this.removeNotificationListeners();
    }

    protected synchronized void handleNotificationListeners() {
        if (!this.muleContext.getNotificationManager().isDisposed()) {
            if (!this.listenersAdded && DefaultMuleConfiguration.isFlowTrace()) {
                this.muleContext.getNotificationManager().addListener((NotificationListener<?>)this.messageProcessorTextDebugger);
                this.muleContext.getNotificationManager().addListener((NotificationListener<?>)this.pipelineProcessorDebugger);
                this.listenersAdded = true;
            } else {
                this.removeNotificationListeners();
            }
        }
    }

    protected synchronized void removeNotificationListeners() {
        if (this.listenersAdded && !this.muleContext.getNotificationManager().isDisposed()) {
            this.muleContext.getNotificationManager().removeListener((NotificationListener<?>)this.messageProcessorTextDebugger);
            this.muleContext.getNotificationManager().removeListener((NotificationListener<?>)this.pipelineProcessorDebugger);
            this.listenersAdded = false;
        }
    }

    public void onMessageProcessorNotificationPreInvoke(MessageProcessorNotification notification) {
        FlowCallStack flowCallStack;
        String resolveProcessorRepresentation = MessageProcessingFlowTraceManager.resolveProcessorRepresentation((String)this.muleContext.getConfiguration().getId(), (String)(notification.getComponent().getLocation() != null ? notification.getComponent().getLocation().getLocation() : null), (Object)notification.getComponent());
        EventContext eventContext = notification.getEventContext();
        if (eventContext != null) {
            ((DefaultProcessorsTrace)((BaseEventContext)eventContext).getProcessorsTrace()).addExecutedProcessors(resolveProcessorRepresentation);
        }
        if ((flowCallStack = ((CoreEvent)notification.getEvent()).getFlowCallStack()) != null) {
            ((DefaultFlowCallStack)flowCallStack).setCurrentProcessorPath(resolveProcessorRepresentation);
        }
    }

    public void onPipelineNotificationComplete(PipelineMessageNotification notification) {
        this.onFlowComplete(notification.getInfo());
    }

    public void onPipelineNotificationStart(PipelineMessageNotification notification) {
        this.onFlowStart(notification.getInfo(), notification.getResourceIdentifier());
    }

    @Override
    public void onFlowStart(EnrichedNotificationInfo notificationInfo, String flowName) {
        FlowCallStack flowCallStack = ((CoreEvent)notificationInfo.getEvent()).getFlowCallStack();
        if (flowCallStack instanceof DefaultFlowCallStack) {
            ((DefaultFlowCallStack)flowCallStack).push(new FlowStackElement(flowName, null));
        }
    }

    @Override
    public void onFlowComplete(EnrichedNotificationInfo notificationInfo) {
        FlowCallStack flowCallStack = ((CoreEvent)notificationInfo.getEvent()).getFlowCallStack();
        if (flowCallStack instanceof DefaultFlowCallStack) {
            ((DefaultFlowCallStack)flowCallStack).pop();
        }
    }

    @Override
    public Map<String, Object> getContextInfo(EnrichedNotificationInfo notificationInfo, Component lastProcessed) {
        FlowCallStack flowCallStack = ((CoreEvent)notificationInfo.getEvent()).getFlowCallStack();
        if (DefaultMuleConfiguration.isFlowTrace()) {
            return Collections.singletonMap(FLOW_STACK_INFO_KEY, flowCallStack.toString());
        }
        return Collections.emptyMap();
    }
}

