/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el.context;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.privileged.el.context.AbstractMapContext;

public class OutboundPropertiesMapContext
extends AbstractMapContext<Serializable> {
    private CoreEvent event;
    private CoreEvent.Builder eventBuilder;

    public OutboundPropertiesMapContext(CoreEvent event, CoreEvent.Builder eventBuilder) {
        this.event = event;
        this.eventBuilder = eventBuilder;
    }

    @Override
    public Serializable doGet(String key) {
        return ((InternalMessage)this.event.getMessage()).getOutboundProperty(key);
    }

    @Override
    public void doPut(String key, Serializable value) {
        this.eventBuilder.message(InternalMessage.builder(this.event.getMessage()).addOutboundProperty(key, value).build());
        this.event = this.eventBuilder.build();
    }

    @Override
    public void doRemove(String key) {
        this.eventBuilder.message(InternalMessage.builder(this.event.getMessage()).removeOutboundProperty(key).build());
        this.event = this.eventBuilder.build();
    }

    @Override
    public Set<String> keySet() {
        return ((InternalMessage)this.event.getMessage()).getOutboundPropertyNames();
    }

    @Override
    public void clear() {
        this.eventBuilder.message(InternalMessage.builder(this.event.getMessage()).outboundProperties(Collections.emptyMap()).build());
        this.event = this.eventBuilder.build();
    }

    public String toString() {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        for (String key : ((InternalMessage)this.event.getMessage()).getOutboundPropertyNames()) {
            Serializable value = ((InternalMessage)this.event.getMessage()).getOutboundProperty(key);
            map.put(key, value);
        }
        return ((Object)map).toString();
    }
}

