/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.core.api.exception.SingleErrorTypeMatcher;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.management.stats.FlowConstructStatistics;
import org.mule.runtime.core.api.processor.AbstractMuleObjectOwner;
import org.mule.runtime.core.internal.component.ComponentAnnotations;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.exception.OnCriticalErrorHandler;
import org.mule.runtime.core.internal.exception.OnErrorPropagateHandler;
import org.mule.runtime.core.internal.message.DefaultExceptionPayload;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.internal.util.MessagingExceptionResolver;
import org.mule.runtime.core.privileged.exception.AbstractExceptionListener;
import org.mule.runtime.core.privileged.exception.MessagingExceptionHandlerAcceptor;
import org.mule.runtime.core.privileged.exception.TemplateOnErrorHandler;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class ErrorHandler
extends AbstractMuleObjectOwner<MessagingExceptionHandlerAcceptor>
implements MessagingExceptionHandlerAcceptor,
MuleContextAware,
Lifecycle {
    private static final String MUST_ACCEPT_ANY_EVENT_MESSAGE = "Default error handler must accept any event.";
    private List<MessagingExceptionHandlerAcceptor> exceptionListeners;
    private String name;
    @Inject
    private NotificationDispatcher notificationDispatcher;

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        this.addCriticalErrorHandler();
        this.addDefaultErrorHandlerIfRequired();
        this.validateConfiguredExceptionStrategies();
    }

    @Override
    public CoreEvent handleException(Exception exception, CoreEvent event) {
        if (!(exception instanceof MessagingException)) {
            exception = new MessagingException(event, (Throwable)exception);
        }
        event = this.addExceptionPayload((Exception)exception, event);
        for (MessagingExceptionHandlerAcceptor exceptionListener : this.exceptionListeners) {
            if (!exceptionListener.accept(event)) continue;
            return exceptionListener.handleException((Exception)exception, event);
        }
        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)MUST_ACCEPT_ANY_EVENT_MESSAGE));
    }

    @Override
    public Publisher<CoreEvent> apply(Exception exception) {
        if (exception instanceof MessagingException) {
            CoreEvent event = this.addExceptionPayload(exception, ((MessagingException)((Object)exception)).getEvent());
            ((MessagingException)((Object)exception)).setProcessedEvent(event);
            try {
                for (MessagingExceptionHandlerAcceptor exceptionListener : this.exceptionListeners) {
                    if (!exceptionListener.accept(event)) continue;
                    return exceptionListener.apply(exception);
                }
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)MUST_ACCEPT_ANY_EVENT_MESSAGE));
            }
            catch (Exception e) {
                return Mono.error((Throwable)((Object)new MessagingExceptionResolver((Component)this).resolve(new MessagingException(event, e, (Component)this), this.muleContext)));
            }
        }
        return Mono.error((Throwable)exception);
    }

    @Override
    protected List<MessagingExceptionHandlerAcceptor> getOwnedObjects() {
        return this.exceptionListeners != null ? Collections.unmodifiableList(this.exceptionListeners) : Collections.emptyList();
    }

    @Override
    public boolean accept(CoreEvent event) {
        return true;
    }

    @Override
    public boolean acceptsAll() {
        return true;
    }

    private CoreEvent addExceptionPayload(Exception exception, CoreEvent event) {
        return CoreEvent.builder(event).message(InternalMessage.builder(event.getMessage()).exceptionPayload(new DefaultExceptionPayload(exception)).build()).build();
    }

    private void addCriticalErrorHandler() {
        this.exceptionListeners.add(0, new OnCriticalErrorHandler(new SingleErrorTypeMatcher((ErrorType)this.muleContext.getErrorTypeRepository().getErrorType(Errors.ComponentIdentifiers.Unhandleable.OVERLOAD).get())));
    }

    private void addDefaultErrorHandlerIfRequired() throws InitialisationException {
        if (!this.exceptionListeners.get(this.exceptionListeners.size() - 1).acceptsAll()) {
            String defaultErrorHandlerName = this.getMuleContext().getConfiguration().getDefaultErrorHandlerName();
            if (defaultErrorHandlerName != null && defaultErrorHandlerName.equals(this.name)) {
                this.logger.warn("Default 'error-handler' should include a final \"catch-all\" 'on-error-propagate'. Attempting implicit injection.");
            }
            OnErrorPropagateHandler acceptsAllOnErrorPropagate = new OnErrorPropagateHandler();
            acceptsAllOnErrorPropagate.setRootContainerName(this.getRootContainerLocation().toString());
            acceptsAllOnErrorPropagate.setNotificationFirer(this.notificationDispatcher);
            LifecycleUtils.initialiseIfNeeded(acceptsAllOnErrorPropagate, this.muleContext);
            this.exceptionListeners.add(acceptsAllOnErrorPropagate);
        }
    }

    private void validateConfiguredExceptionStrategies() {
        this.validateOnlyLastAcceptsAll();
    }

    private void validateOnlyLastAcceptsAll() {
        for (int i = 0; i < this.exceptionListeners.size() - 1; ++i) {
            MessagingExceptionHandlerAcceptor messagingExceptionHandlerAcceptor = this.exceptionListeners.get(i);
            if (!messagingExceptionHandlerAcceptor.acceptsAll()) continue;
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Only last exception strategy inside <error-handler> can accept any message. Maybe expression attribute is empty."));
        }
    }

    public void setExceptionListeners(List<MessagingExceptionHandlerAcceptor> exceptionListeners) {
        this.exceptionListeners = exceptionListeners;
    }

    public List<MessagingExceptionHandlerAcceptor> getExceptionListeners() {
        return Collections.unmodifiableList(this.exceptionListeners);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRootContainerName(String rootContainerName) {
        ComponentAnnotations.updateRootContainerName(rootContainerName, (Component)this);
        for (MessagingExceptionHandlerAcceptor exceptionListener : this.exceptionListeners) {
            if (!(exceptionListener instanceof TemplateOnErrorHandler)) continue;
            ((TemplateOnErrorHandler)exceptionListener).setRootContainerName(rootContainerName);
        }
    }

    public void setStatistics(FlowConstructStatistics flowStatistics) {
        for (MessagingExceptionHandlerAcceptor exceptionListener : this.exceptionListeners) {
            if (!(exceptionListener instanceof AbstractExceptionListener)) continue;
            ((AbstractExceptionListener)((Object)exceptionListener)).setStatistics(flowStatistics);
        }
    }
}

