/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.policy.Policy;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.policy.PolicyEventMapper;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class OperationPolicyProcessor
implements ReactiveProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationPolicyProcessor.class);
    private final Policy policy;
    private final ReactiveProcessor nextProcessor;
    private final PolicyEventMapper policyEventMapper;

    public OperationPolicyProcessor(Policy policy, ReactiveProcessor nextProcessor) {
        this.policy = policy;
        this.nextProcessor = nextProcessor;
        this.policyEventMapper = new PolicyEventMapper(policy.getPolicyId());
    }

    @Override
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return Flux.from(publisher).map(this.policyEventMapper::onOperationPolicyBegin).doOnNext(event -> this.logPolicy(event.getContext().getCorrelationId(), this.policy.getPolicyId(), () -> this.getMessageAttributesAsString((CoreEvent)event), "Before operation")).transform((Function)this.policy.getPolicyChain().onChainError(t -> this.manageError((MessagingException)((Object)((Object)t))))).subscriberContext(ctx -> ctx.put((Object)"policy.nextOperation", (Object)this.nextProcessor)).map(policyChainResult -> this.policyEventMapper.onOperationPolicyFinish((CoreEvent)policyChainResult, this.policy.getPolicyChain().isPropagateMessageTransformations())).doOnNext(event -> this.logPolicy(event.getContext().getCorrelationId(), this.policy.getPolicyId(), () -> this.getMessageAttributesAsString((CoreEvent)event), "After operation"));
    }

    private void manageError(MessagingException messagingException) {
        messagingException.setProcessedEvent(this.policyEventMapper.onOperationPolicyError(messagingException.getEvent()));
    }

    private String getMessageAttributesAsString(CoreEvent event) {
        if (event.getMessage() == null || event.getMessage().getAttributes() == null || event.getMessage().getAttributes().getValue() == null) {
            return "";
        }
        return event.getMessage().getAttributes().getValue().toString();
    }

    private void logPolicy(String eventId, String policyName, Supplier<String> message, String startingMessage) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Event Id: " + eventId + ".\n" + startingMessage + "\nPolicy:" + policyName + "\n" + message.get());
        }
    }
}

