/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.inject.Inject;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.notification.AsyncMessageNotification;
import org.mule.runtime.api.notification.EnrichedNotificationInfo;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.Pipeline;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.LoggingExceptionHandler;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.AbstractMessageProcessorOwner;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Sink;
import org.mule.runtime.core.api.processor.strategy.AsyncProcessingStrategyFactory;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.component.ComponentUtils;
import org.mule.runtime.core.internal.event.DefaultEventContext;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.processor.strategy.DirectProcessingStrategyFactory;
import org.mule.runtime.core.internal.util.rx.Operators;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.event.DefaultMuleSession;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.Scope;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChainBuilder;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class AsyncDelegateMessageProcessor
extends AbstractMessageProcessorOwner
implements Scope,
Initialisable,
Startable,
Stoppable {
    @Inject
    private MuleContext muleContext;
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private ConfigurationComponentLocator componentLocator;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private ProcessingStrategy processingStrategy;
    private Sink sink;
    private final MessageProcessorChainBuilder delegateBuilder;
    protected MessageProcessorChain delegate;
    private org.mule.runtime.api.scheduler.Scheduler scheduler;
    private Scheduler reactorScheduler;
    protected String name;
    private Integer maxConcurrency;

    public AsyncDelegateMessageProcessor(MessageProcessorChainBuilder delegate) {
        this.delegateBuilder = delegate;
    }

    public AsyncDelegateMessageProcessor(MessageProcessorChainBuilder delegate, String name) {
        this.delegateBuilder = delegate;
        this.name = name;
    }

    @Override
    public void initialise() throws InitialisationException {
        Component rootContainer = ComponentUtils.getFromAnnotatedObject(this.componentLocator, this).orElse(null);
        if (rootContainer != null && !Objects.equals(rootContainer.getLocation().getLocation(), this.getLocation().getRootContainerName())) {
            this.processingStrategy = this.defaultProcessingStrategy().create(this.getMuleContext(), this.getLocation().getLocation());
        } else if (rootContainer instanceof Pipeline) {
            if (this.maxConcurrency != null) {
                ProcessingStrategyFactory flowPsFactory = ((Pipeline)rootContainer).getProcessingStrategyFactory();
                if (flowPsFactory instanceof AsyncProcessingStrategyFactory) {
                    ((AsyncProcessingStrategyFactory)flowPsFactory).setMaxConcurrency(this.maxConcurrency);
                    ((AsyncProcessingStrategyFactory)flowPsFactory).setMaxConcurrencyEagerCheck(false);
                } else {
                    this.logger.warn("{} does not support 'maxConcurrency'. Ignoring the value.", (Object)flowPsFactory.getClass().getSimpleName());
                }
                this.processingStrategy = flowPsFactory.create(this.muleContext, this.getLocation().getLocation());
            } else {
                ProcessingStrategyFactory flowPsFactory = ((Pipeline)rootContainer).getProcessingStrategyFactory();
                if (flowPsFactory instanceof AsyncProcessingStrategyFactory) {
                    ((AsyncProcessingStrategyFactory)flowPsFactory).setMaxConcurrencyEagerCheck(false);
                }
                this.processingStrategy = flowPsFactory.create(this.muleContext, this.getLocation().getLocation());
            }
        } else {
            this.processingStrategy = this.createDefaultProcessingStrategyFactory().create(this.getMuleContext(), this.getLocation().getLocation());
        }
        if (this.delegateBuilder == null) {
            throw new InitialisationException(CoreMessages.objectIsNull("delegate message processor"), (Initialisable)this);
        }
        this.delegateBuilder.setProcessingStrategy(this.processingStrategy);
        this.delegate = this.delegateBuilder.build();
        LifecycleUtils.initialiseIfNeeded(this.delegate, this.muleContext);
        super.initialise();
    }

    protected ProcessingStrategyFactory createDefaultProcessingStrategyFactory() {
        return new DirectProcessingStrategyFactory();
    }

    private ProcessingStrategyFactory defaultProcessingStrategy() {
        ProcessingStrategyFactory defaultProcessingStrategyFactory = this.getMuleContext().getConfiguration().getDefaultProcessingStrategyFactory();
        if (defaultProcessingStrategyFactory == null) {
            return this.createDefaultProcessingStrategyFactory();
        }
        return defaultProcessingStrategyFactory;
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.processingStrategy);
        this.sink = this.processingStrategy.createSink(ComponentUtils.getFromAnnotatedObject(this.componentLocator, this).filter(c -> c instanceof FlowConstruct).orElse(null), this.processAsyncChainFunction());
        this.scheduler = this.processingStrategy.isSynchronous() ? this.schedulerService.ioScheduler(this.muleContext.getSchedulerBaseConfig().withName(this.name != null ? this.name : this.getLocation().getLocation())) : this.schedulerService.cpuLightScheduler(this.muleContext.getSchedulerBaseConfig().withName(this.name != null ? this.name : this.getLocation().getLocation()));
        this.reactorScheduler = Schedulers.fromExecutorService((ExecutorService)this.scheduler);
        LifecycleUtils.startIfNeeded(this.delegate);
        super.start();
    }

    @Override
    public void stop() throws MuleException {
        super.stop();
        LifecycleUtils.stopIfNeeded(this.delegate);
        if (this.scheduler != null) {
            this.scheduler.stop();
            this.scheduler = null;
        }
        if (this.reactorScheduler != null) {
            this.reactorScheduler.dispose();
            this.reactorScheduler = null;
        }
        LifecycleUtils.disposeIfNeeded(this.sink, this.logger);
        this.sink = null;
        LifecycleUtils.stopIfNeeded(this.processingStrategy);
    }

    @Override
    public void dispose() {
        super.dispose();
        LifecycleUtils.disposeIfNeeded(this.delegate, this.logger);
    }

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        return MessageProcessors.processToApply(event, this);
    }

    @Override
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return Flux.from(publisher).cast(PrivilegedEvent.class).doOnNext(request -> {
            Flux asyncPublisher = Flux.just((Object)request).map(event -> this.asyncEvent((PrivilegedEvent)event));
            if (TransactionCoordination.isTransactionActive() && !this.processingStrategy.isSynchronous()) {
                asyncPublisher = asyncPublisher.publishOn(this.reactorScheduler);
            }
            asyncPublisher.map(event -> {
                this.sink.accept((CoreEvent)event);
                return event;
            }).subscribe(Operators.requestUnbounded());
        }).cast(CoreEvent.class);
    }

    private CoreEvent asyncEvent(PrivilegedEvent event) {
        return PrivilegedEvent.builder(DefaultEventContext.child(event.getContext(), Optional.ofNullable(this.getLocation()), LoggingExceptionHandler.getInstance()), event).session(new DefaultMuleSession(event.getSession())).build();
    }

    private ReactiveProcessor processAsyncChainFunction() {
        return innerPublisher -> Flux.from((Publisher)innerPublisher).doOnNext(this.fireAsyncScheduledNotification()).transform((Function)this.processingStrategy.onPipeline(this.scheduleAsync(this.delegate))).doOnNext(event -> {
            this.fireAsyncCompleteNotification((CoreEvent)event, null);
            ((BaseEventContext)event.getContext()).success((CoreEvent)event);
        }).doOnError(MessagingException.class, e -> {
            this.fireAsyncCompleteNotification(e.getEvent(), (MessagingException)((Object)((Object)e)));
            ((BaseEventContext)e.getEvent().getContext()).error((Throwable)((Object)e));
        }).doOnError(throwable -> this.logger.warn("Error occurred during asynchronous processing at:" + this.getLocation().getLocation() + " . To handle this error include a <try> scope in the <async> scope.", throwable));
    }

    private ReactiveProcessor scheduleAsync(Processor delegate) {
        if (this.processingStrategy.isSynchronous()) {
            return publisher -> Flux.from((Publisher)publisher).transform((Function)delegate).subscribeOn(this.reactorScheduler);
        }
        return delegate;
    }

    private Consumer<CoreEvent> fireAsyncScheduledNotification() {
        return event -> this.muleContext.getNotificationManager().fireNotification((Notification)new AsyncMessageNotification(EnrichedNotificationInfo.createInfo((Event)event, null, (Component)this), this.getLocation(), 1901));
    }

    private void fireAsyncCompleteNotification(CoreEvent event, MessagingException exception) {
        this.muleContext.getNotificationManager().fireNotification((Notification)new AsyncMessageNotification(EnrichedNotificationInfo.createInfo((Event)event, (Exception)((Object)exception), (Component)this), this.getLocation(), 1902));
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        return Collections.singletonList(this.delegate);
    }

    public void setMaxConcurrency(Integer maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
    }

    @Override
    protected List<Processor> getOwnedObjects() {
        return Collections.emptyList();
    }
}

