/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Sink;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.processor.strategy.AbstractStreamProcessingStrategyFactory;
import org.mule.runtime.core.internal.processor.strategy.DirectSink;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import reactor.core.publisher.FluxSink;
import reactor.util.concurrent.Queues;

public abstract class AbstractProcessingStrategy
implements ProcessingStrategy {
    public static final String TRANSACTIONAL_ERROR_MESSAGE = "Unable to process a transactional flow asynchronously";
    public static final String PROCESSOR_SCHEDULER_CONTEXT_KEY = "mule.nb.processorScheduler";
    protected static final long SCHEDULER_BUSY_RETRY_INTERVAL_MS = 2L;

    @Override
    public Sink createSink(FlowConstruct flowConstruct, ReactiveProcessor pipeline) {
        return new DirectSink(pipeline, this.createOnEventConsumer(), Queues.SMALL_BUFFER_SIZE);
    }

    protected Consumer<CoreEvent> createOnEventConsumer() {
        return event -> {
            if (TransactionCoordination.isTransactionActive()) {
                ((BaseEventContext)event.getContext()).error((Throwable)((Object)new MessagingException((CoreEvent)event, (Throwable)new DefaultMuleException(I18nMessageFactory.createStaticMessage((String)TRANSACTIONAL_ERROR_MESSAGE)))));
            }
        };
    }

    protected ScheduledExecutorService decorateScheduler(ScheduledExecutorService scheduler) {
        return scheduler;
    }

    protected boolean isSchedulerBusy(Throwable t) {
        Throwable cause = Exceptions.unwrap(t);
        return RejectedExecutionException.class.isAssignableFrom(cause.getClass()) || this.isOverloadError(cause);
    }

    private boolean isOverloadError(Throwable cause) {
        if (cause instanceof MessagingException) {
            return ((MessagingException)((Object)cause)).getEvent().getError().map(e -> e.getErrorType()).filter(errorType -> Errors.ComponentIdentifiers.Unhandleable.OVERLOAD.getName().equals(errorType.getIdentifier()) && Errors.ComponentIdentifiers.Unhandleable.OVERLOAD.getNamespace().equals(errorType.getNamespace())).isPresent();
        }
        return false;
    }

    static class DefaultReactorSink<E>
    implements ReactorSink<E> {
        private final FluxSink<E> fluxSink;
        private final reactor.core.Disposable disposable;
        private final Consumer onEventConsumer;
        private final int bufferSize;

        DefaultReactorSink(FluxSink<E> fluxSink, reactor.core.Disposable disposable, Consumer<CoreEvent> onEventConsumer, int bufferSize) {
            this.fluxSink = fluxSink;
            this.disposable = disposable;
            this.onEventConsumer = onEventConsumer;
            this.bufferSize = bufferSize;
        }

        @Override
        public final void accept(CoreEvent event) {
            this.onEventConsumer.accept(event);
            this.fluxSink.next(this.intoSink(event));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean emit(CoreEvent event) {
            this.onEventConsumer.accept(event);
            long remainingCapacity = this.fluxSink.requestedFromDownstream();
            if (remainingCapacity == 0L) {
                return false;
            }
            if (remainingCapacity > (long)(this.bufferSize > AbstractStreamProcessingStrategyFactory.CORES * 4 ? AbstractStreamProcessingStrategyFactory.CORES : 0)) {
                this.fluxSink.next(this.intoSink(event));
                return true;
            }
            FluxSink<E> fluxSink = this.fluxSink;
            synchronized (fluxSink) {
                if (remainingCapacity > 0L) {
                    this.fluxSink.next(this.intoSink(event));
                    return true;
                }
                return false;
            }
        }

        @Override
        public E intoSink(CoreEvent event) {
            return (E)event;
        }

        public final void dispose() {
            this.fluxSink.complete();
            this.disposable.dispose();
        }
    }

    static interface ReactorSink<E>
    extends Sink,
    Disposable {
        public E intoSink(CoreEvent var1);
    }
}

