/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.AsyncProcessingStrategyFactory;

public abstract class AbstractProcessingStrategyFactory
implements AsyncProcessingStrategyFactory {
    private int maxConcurrency = DEFAULT_MAX_CONCURRENCY;
    private boolean maxConcurrencyEagerCheck = true;

    @Override
    public void setMaxConcurrency(int maxConcurrency) {
        if (maxConcurrency < 1) {
            throw new IllegalArgumentException("maxConcurrency must be at least 1");
        }
        this.maxConcurrency = maxConcurrency;
    }

    protected int getMaxConcurrency() {
        return this.maxConcurrency;
    }

    @Override
    public void setMaxConcurrencyEagerCheck(boolean maxConcurrencyEagerCheck) {
        this.maxConcurrencyEagerCheck = maxConcurrencyEagerCheck;
    }

    public boolean isMaxConcurrencyEagerCheck() {
        return this.maxConcurrencyEagerCheck;
    }

    protected SchedulerConfig createSchedulerConfig(MuleContext muleContext, String schedulersNamePrefix, ReactiveProcessor.ProcessingType processingType) {
        SchedulerConfig schedulerConfig = muleContext.getSchedulerBaseConfig().withName(schedulersNamePrefix + "." + processingType.name());
        if (this.getMaxConcurrency() != Integer.MAX_VALUE) {
            schedulerConfig = schedulerConfig.withMaxConcurrentTasks(this.getMaxConcurrency());
        }
        return schedulerConfig;
    }
}

