/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.processor.strategy.AbstractStreamProcessingStrategyFactory;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

abstract class AbstractReactorStreamProcessingStrategy
extends AbstractStreamProcessingStrategyFactory.AbstractStreamProcessingStrategy
implements Startable,
Stoppable {
    private final Supplier<org.mule.runtime.api.scheduler.Scheduler> cpuLightSchedulerSupplier;
    private org.mule.runtime.api.scheduler.Scheduler cpuLightScheduler;
    private final int parallelism;

    AbstractReactorStreamProcessingStrategy(int subscribers, Supplier<org.mule.runtime.api.scheduler.Scheduler> cpuLightSchedulerSupplier, int parallelism, int maxConcurrency, boolean maxConcurrencyEagerCheck) {
        super(subscribers, maxConcurrency, maxConcurrencyEagerCheck);
        this.cpuLightSchedulerSupplier = cpuLightSchedulerSupplier;
        this.parallelism = parallelism;
    }

    @Override
    public ReactiveProcessor onProcessor(ReactiveProcessor processor) {
        Scheduler cpuLiteScheduler = Schedulers.fromExecutorService((ExecutorService)this.decorateScheduler((ScheduledExecutorService)this.getCpuLightScheduler()));
        if (processor.getProcessingType() == ReactiveProcessor.ProcessingType.CPU_LITE_ASYNC) {
            return publisher -> Flux.from((Publisher)publisher).transform((Function)processor).publishOn(cpuLiteScheduler).subscriberContext(ctx -> ctx.put((Object)"mule.nb.processorScheduler", (Object)this.getCpuLightScheduler()));
        }
        return publisher -> Flux.from((Publisher)publisher).transform((Function)processor).subscriberContext(ctx -> ctx.put((Object)"mule.nb.processorScheduler", (Object)this.getCpuLightScheduler()));
    }

    protected int getParallelism() {
        return this.parallelism;
    }

    public void start() throws MuleException {
        this.cpuLightScheduler = this.createCpuLightScheduler(this.cpuLightSchedulerSupplier);
    }

    protected org.mule.runtime.api.scheduler.Scheduler createCpuLightScheduler(Supplier<org.mule.runtime.api.scheduler.Scheduler> cpuLightSchedulerSupplier) {
        return cpuLightSchedulerSupplier.get();
    }

    public void stop() throws MuleException {
        if (this.cpuLightScheduler != null) {
            this.cpuLightScheduler.stop();
        }
    }

    protected org.mule.runtime.api.scheduler.Scheduler getCpuLightScheduler() {
        return this.cpuLightScheduler;
    }
}

