/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Sink;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.internal.processor.strategy.AbstractReactorStreamProcessingStrategy;
import org.mule.runtime.core.internal.processor.strategy.AbstractStreamWorkQueueProcessingStrategyFactory;
import org.mule.runtime.core.internal.processor.strategy.WorkQueueStreamProcessingStrategyFactory;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class ReactorStreamProcessingStrategyFactory
extends AbstractStreamWorkQueueProcessingStrategyFactory {
    @Override
    public ProcessingStrategy create(MuleContext muleContext, String schedulersNamePrefix) {
        return new ReactorStreamProcessingStrategy(this.getRingBufferSchedulerSupplier(muleContext, schedulersNamePrefix), this.getBufferSize(), this.getSubscriberCount(), this.getWaitStrategy(), this.getCpuLightSchedulerSupplier(muleContext, schedulersNamePrefix), this.resolveParallelism(), this.getMaxConcurrency(), this.isMaxConcurrencyEagerCheck());
    }

    protected int resolveParallelism() {
        if (this.getMaxConcurrency() == Integer.MAX_VALUE) {
            return Math.max(CORES / this.getSubscriberCount(), 1);
        }
        return Math.min(CORES, Math.max(this.getMaxConcurrency() / this.getSubscriberCount(), 1));
    }

    protected Supplier<org.mule.runtime.api.scheduler.Scheduler> getCpuLightSchedulerSupplier(MuleContext muleContext, String schedulersNamePrefix) {
        return () -> muleContext.getSchedulerService().cpuLightScheduler(muleContext.getSchedulerBaseConfig().withName(schedulersNamePrefix + "." + ReactiveProcessor.ProcessingType.CPU_LITE.name()));
    }

    @Override
    public Class<? extends ProcessingStrategy> getProcessingStrategyType() {
        return ReactorStreamProcessingStrategy.class;
    }

    static class ReactorStreamProcessingStrategy
    extends AbstractReactorStreamProcessingStrategy
    implements Startable,
    Stoppable {
        private final WorkQueueStreamProcessingStrategyFactory.WorkQueueStreamProcessingStrategy workQueueStreamProcessingStrategy;

        ReactorStreamProcessingStrategy(Supplier<org.mule.runtime.api.scheduler.Scheduler> ringBufferSchedulerSupplier, int bufferSize, int subscribers, String waitStrategy, Supplier<org.mule.runtime.api.scheduler.Scheduler> cpuLightSchedulerSupplier, int parallelism, int maxConcurrency, boolean maxConcurrencyEagerCheck) {
            super(subscribers, cpuLightSchedulerSupplier, parallelism, maxConcurrency, maxConcurrencyEagerCheck);
            this.workQueueStreamProcessingStrategy = new WorkQueueStreamProcessingStrategyFactory.WorkQueueStreamProcessingStrategy(ringBufferSchedulerSupplier, bufferSize, subscribers, waitStrategy, cpuLightSchedulerSupplier, maxConcurrency, maxConcurrencyEagerCheck);
        }

        @Override
        public Sink createSink(FlowConstruct flowConstruct, ReactiveProcessor pipeline) {
            return this.workQueueStreamProcessingStrategy.createSink(flowConstruct, pipeline);
        }

        @Override
        public ReactiveProcessor onPipeline(ReactiveProcessor pipeline) {
            Scheduler scheduler = Schedulers.fromExecutorService((ExecutorService)this.decorateScheduler((ScheduledExecutorService)this.getCpuLightScheduler()));
            if (this.maxConcurrency > this.subscribers) {
                return publisher -> Flux.from((Publisher)publisher).parallel(this.getParallelism()).runOn(scheduler).composeGroup((Function)super.onPipeline(pipeline));
            }
            return super.onPipeline(pipeline);
        }
    }
}

