/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.domain;

import java.util.Collections;
import java.util.LinkedHashMap;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.el.DataTypeAware;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.util.CaseInsensitiveMapWrapper;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.OptimizedCaseInsensitiveMapWrapper;

@NoExtend
public class CaseInsensitiveMultiMap
extends MultiMap<String, String>
implements DataTypeAware {
    private static final long serialVersionUID = -3754163327838153655L;
    protected final boolean optimized;

    public CaseInsensitiveMultiMap() {
        this(true);
    }

    public CaseInsensitiveMultiMap(boolean optimized) {
        this.optimized = optimized;
        this.paramsMap = optimized ? new OptimizedCaseInsensitiveMapWrapper(new LinkedHashMap()) : new CaseInsensitiveMapWrapper(new LinkedHashMap());
    }

    public CaseInsensitiveMultiMap(MultiMap<String, String> paramsMap) {
        this(paramsMap, true);
    }

    public CaseInsensitiveMultiMap(MultiMap<String, String> paramsMap, boolean optimized) {
        this.optimized = optimized;
        this.paramsMap = optimized ? new OptimizedCaseInsensitiveMapWrapper(new LinkedHashMap()) : new CaseInsensitiveMapWrapper(new LinkedHashMap());
        this.putAll(paramsMap);
    }

    public CaseInsensitiveMultiMap toImmutableMultiMap() {
        if (this instanceof ImmutableCaseInsensitiveMultiMap) {
            return this;
        }
        return new ImmutableCaseInsensitiveMultiMap(this);
    }

    public DataType getDataType() {
        return DataType.MULTI_MAP_STRING_STRING;
    }

    private static class ImmutableCaseInsensitiveMultiMap
    extends CaseInsensitiveMultiMap {
        private static final long serialVersionUID = -1048913048598100657L;

        public ImmutableCaseInsensitiveMultiMap(CaseInsensitiveMultiMap caseInsensitiveMultiMap) {
            super(caseInsensitiveMultiMap, caseInsensitiveMultiMap.optimized);
            this.paramsMap = Collections.unmodifiableMap(this.paramsMap);
        }
    }
}

