/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.policy.CommonSourcePolicy;
import org.mule.runtime.core.internal.policy.MessageSourceResponseParametersProcessor;
import org.mule.runtime.core.internal.policy.SourcePolicy;
import org.mule.runtime.core.internal.policy.SourcePolicyFailureResult;
import org.mule.runtime.core.internal.policy.SourcePolicySuccessResult;
import org.mule.runtime.core.internal.rx.FluxSinkRecorder;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

public class NoSourcePolicy
implements SourcePolicy,
Disposable {
    private final CommonSourcePolicy commonPolicy;

    public NoSourcePolicy(ReactiveProcessor flowExecutionProcessor) {
        this.commonPolicy = new CommonSourcePolicy(new SourceFluxObjectFactory(flowExecutionProcessor));
    }

    @Override
    public Publisher<Either<SourcePolicyFailureResult, SourcePolicySuccessResult>> process(CoreEvent sourceEvent, MessageSourceResponseParametersProcessor respParamProcessor) {
        return this.commonPolicy.process(sourceEvent, respParamProcessor);
    }

    public void dispose() {
        this.commonPolicy.dispose();
    }

    private final class SourceFluxObjectFactory
    implements Supplier<FluxSink<CoreEvent>> {
        private final ReactiveProcessor flowExecutionProcessor;

        public SourceFluxObjectFactory(ReactiveProcessor flowExecutionProcessor) {
            this.flowExecutionProcessor = flowExecutionProcessor;
        }

        @Override
        public FluxSink<CoreEvent> get() {
            FluxSinkRecorder sinkRef = new FluxSinkRecorder();
            Flux policyFlux = Flux.create(sinkRef).transform((Function)this.flowExecutionProcessor).map(flowExecutionResult -> {
                MessageSourceResponseParametersProcessor parametersProcessor = NoSourcePolicy.this.commonPolicy.getResponseParamsProcessor((CoreEvent)flowExecutionResult);
                return Either.right(SourcePolicyFailureResult.class, new SourcePolicySuccessResult((CoreEvent)flowExecutionResult, () -> parametersProcessor.getSuccessfulExecutionResponseParametersFunction().apply((CoreEvent)flowExecutionResult), parametersProcessor));
            }).doOnNext(result -> result.apply(spfr -> NoSourcePolicy.this.commonPolicy.finishFlowProcessing(spfr.getMessagingException().getEvent(), (Either<SourcePolicyFailureResult, SourcePolicySuccessResult>)result, (Throwable)((Object)spfr.getMessagingException())), spsr -> NoSourcePolicy.this.commonPolicy.finishFlowProcessing(spsr.getResult(), (Either<SourcePolicyFailureResult, SourcePolicySuccessResult>)result))).onErrorContinue(MessagingException.class, (t, e) -> {
                MessagingException me = (MessagingException)((Object)((Object)t));
                InternalEvent event = (InternalEvent)me.getEvent();
                NoSourcePolicy.this.commonPolicy.finishFlowProcessing(event, Either.left(new SourcePolicyFailureResult(me, () -> NoSourcePolicy.this.commonPolicy.getResponseParamsProcessor(event).getFailedExecutionResponseParametersFunction().apply(me.getEvent()))), (Throwable)((Object)me));
            });
            policyFlux.subscribe();
            return sinkRef.getFluxSink();
        }
    }
}

