/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.message;

import java.util.Iterator;
import java.util.function.Consumer;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.streaming.HasSize;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.internal.util.message.MessageUtils;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.extension.api.runtime.operation.Result;

final class ResultToMessageIterator
implements Iterator<Message>,
HasSize {
    private final Iterator<Object> delegate;
    private final CursorProviderFactory cursorProviderFactory;
    private final BaseEventContext eventContext;

    ResultToMessageIterator(Iterator<Object> delegate, CursorProviderFactory cursorProviderFactory, BaseEventContext eventContext) {
        this.delegate = delegate;
        this.cursorProviderFactory = cursorProviderFactory;
        this.eventContext = eventContext;
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public Message next() {
        Object value = this.delegate.next();
        if (value instanceof Message) {
            return (Message)value;
        }
        return MessageUtils.toMessage((Result)value, this.cursorProviderFactory, this.eventContext);
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }

    public int getSize() {
        return this.delegate instanceof HasSize ? ((HasSize)this.delegate).getSize() : -1;
    }

    @Override
    public void forEachRemaining(Consumer<? super Message> action) {
        this.delegate.forEachRemaining((? super E value) -> {
            if (value instanceof Result) {
                value = MessageUtils.toMessage((Result)value, this.cursorProviderFactory, this.eventContext);
            }
            action.accept((Message)value);
        });
    }
}

