/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.component;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.CallbackHelper;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.proxy.NoOp;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.internal.component.DynamicallyComponent;
import org.mule.runtime.core.internal.component.DynamicallySerializableComponent;
import org.mule.runtime.core.internal.util.CompositeClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnnotatedObjectInvocationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotatedObjectInvocationHandler.class);
    private static final Set<Method> MANAGED_METHODS = Collections.unmodifiableSet(new HashSet<Method>(Arrays.asList(Component.class.getDeclaredMethods())));

    public static <T, A extends Component> Class<A> addAnnotationsToClass(Class<T> clazz) {
        Class<DynamicallyComponent> dynamicInterface;
        if (Component.class.isAssignableFrom(clazz) && Arrays.asList(clazz.getMethods()).stream().anyMatch(m -> "getAnnotations".equals(m.getName()) && !m.isDefault())) {
            return clazz;
        }
        if (Modifier.isFinal(clazz.getModifiers())) {
            throw new UnsupportedOperationException("Class '" + clazz.getName() + "' must either not be final or implement '" + Component.class.getName() + "'");
        }
        if (Serializable.class.isAssignableFrom(clazz)) {
            try {
                clazz.getConstructor(new Class[0]);
                dynamicInterface = DynamicallySerializableComponent.class;
            }
            catch (SecurityException e) {
                throw new UnsupportedOperationException("Class '" + clazz.getName() + "' cannot be enhanced for annotations (" + e.getMessage() + ")", e);
            }
            catch (NoSuchMethodException e) {
                LOGGER.warn("Class '" + clazz.getName() + "' implements Serializable but does not provide a default public constructor. The mechanism to add annotations dynamically requires a default public constructor in a Serializable class.");
                dynamicInterface = DynamicallyComponent.class;
            }
        } else {
            dynamicInterface = DynamicallyComponent.class;
        }
        Enhancer enhancer = new Enhancer();
        enhancer.setInterfaces(new Class[]{dynamicInterface});
        enhancer.setSuperclass(clazz);
        final ComponentInterceptor annotatedObjectInvocationHandler = new ComponentInterceptor(MANAGED_METHODS);
        final MethodInterceptor removeDynamicAnnotationsInterceptor = (obj, method, args, proxy) -> AnnotatedObjectInvocationHandler.removeDynamicAnnotations(obj);
        CallbackHelper callbackHelper = new CallbackHelper(clazz, new Class[]{dynamicInterface}){

            protected Object getCallback(Method method) {
                if (MANAGED_METHODS.contains(method) || annotatedObjectInvocationHandler.getOverridingMethods().containsKey(method)) {
                    return annotatedObjectInvocationHandler;
                }
                if ("writeReplace".equals(method.getName())) {
                    return removeDynamicAnnotationsInterceptor;
                }
                Optional<Method> overridingMethod = MANAGED_METHODS.stream().filter(m -> m.getName().equals(method.getName()) && Arrays.equals(m.getParameterTypes(), method.getParameterTypes())).findFirst();
                if (overridingMethod.isPresent()) {
                    annotatedObjectInvocationHandler.getOverridingMethods().put(method, overridingMethod.get());
                    return annotatedObjectInvocationHandler;
                }
                return NoOp.INSTANCE;
            }
        };
        enhancer.setCallbackTypes(callbackHelper.getCallbackTypes());
        enhancer.setCallbackFilter((CallbackFilter)callbackHelper);
        if (Enhancer.class.getClassLoader() != clazz.getClassLoader()) {
            enhancer.setClassLoader((ClassLoader)new CompositeClassLoader(AnnotatedObjectInvocationHandler.class.getClassLoader(), clazz.getClassLoader()));
            enhancer.setUseCache(false);
        }
        Class annotatedClass = enhancer.createClass();
        Enhancer.registerStaticCallbacks((Class)annotatedClass, (Callback[])callbackHelper.getCallbacks());
        return annotatedClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, A> T removeDynamicAnnotations(A annotated) {
        if (annotated instanceof DynamicallyComponent) {
            Class<?> baseClass = annotated.getClass().getSuperclass();
            HashMap<String, Object> fieldsByName = new HashMap<String, Object>();
            for (Class<?> currentClass = baseClass; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
                Field[] targetFields = currentClass.getDeclaredFields();
                for (Field field : targetFields) {
                    if (Modifier.isStatic(field.getModifiers()) || fieldsByName.containsKey(field.getName())) continue;
                    fieldsByName.put(field.getName(), field);
                }
            }
            try {
                Object base = baseClass.newInstance();
                for (Field field : fieldsByName.values()) {
                    boolean acc = field.isAccessible();
                    field.setAccessible(true);
                    try {
                        field.set(base, field.get(annotated));
                    }
                    finally {
                        field.setAccessible(acc);
                    }
                }
                return (T)base;
            }
            catch (Exception e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
        return (T)annotated;
    }

    private static class ComponentInterceptor
    extends AbstractComponent
    implements MethodInterceptor {
        private Map<Method, Method> overridingMethods = Collections.synchronizedMap(new HashMap());

        public ComponentInterceptor(Set<Method> managedMethods) {
            for (Method method : managedMethods) {
                this.overridingMethods.put(method, method);
            }
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            if (this.overridingMethods.containsKey(method)) {
                return this.overridingMethods.get(method).invoke((Object)this, args);
            }
            return proxy.invokeSuper(obj, args);
        }

        public Map<Method, Method> getOverridingMethods() {
            return this.overridingMethods;
        }
    }
}

