/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence.reduced;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.FunctionType;
import org.mule.metadata.api.model.IntersectionType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;

class CatalogTypeCollectorMetadataTypeVisitor
extends MetadataTypeVisitor {
    private final Map<String, ObjectType> registeredTypes = new HashMap<String, ObjectType>();

    CatalogTypeCollectorMetadataTypeVisitor() {
    }

    public void visitObject(ObjectType type) {
        Optional typeId = MetadataTypeUtils.getTypeId((MetadataType)type);
        if (typeId.isPresent()) {
            String id = (String)typeId.get();
            if (this.registeredTypes.containsKey(id)) {
                return;
            }
            this.registeredTypes.put(id, type);
        }
        type.getOpenRestriction().ifPresent(t -> t.accept((MetadataTypeVisitor)this));
        type.getFields().forEach(field -> field.getValue().accept((MetadataTypeVisitor)this));
    }

    public void visitArrayType(ArrayType arrayType) {
        arrayType.getType().accept((MetadataTypeVisitor)this);
    }

    public void visitFunction(FunctionType functionType) {
        functionType.getParameters().forEach(p -> p.getType().accept((MetadataTypeVisitor)this));
        functionType.getReturnType().ifPresent(rt -> rt.accept((MetadataTypeVisitor)this));
    }

    public void visitIntersection(IntersectionType intersectionType) {
        intersectionType.getTypes().forEach(t -> t.accept((MetadataTypeVisitor)this));
    }

    public void visitUnion(UnionType unionType) {
        unionType.getTypes().forEach(t -> t.accept((MetadataTypeVisitor)this));
    }

    public Map<String, ObjectType> getCatalog() {
        return ImmutableMap.copyOf(this.registeredTypes);
    }
}

