/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.util.Collection;
import java.util.Map;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.policy.api.OperationPolicyPointcutParametersFactory;
import org.mule.runtime.policy.api.PolicyPointcutParameters;
import org.mule.runtime.policy.api.SourcePolicyPointcutParametersFactory;

public class PolicyPointcutParametersManager {
    static final String POLICY_SOURCE_POINTCUT_PARAMETERS = "policy.sourcePointcutParameters";
    private final Collection<SourcePolicyPointcutParametersFactory> sourcePointcutFactories;
    private final Collection<OperationPolicyPointcutParametersFactory> operationPointcutFactories;

    public PolicyPointcutParametersManager(Collection<SourcePolicyPointcutParametersFactory> sourcePointcutFactories, Collection<OperationPolicyPointcutParametersFactory> operationPointcutFactories) {
        this.sourcePointcutFactories = sourcePointcutFactories;
        this.operationPointcutFactories = operationPointcutFactories;
    }

    public PolicyPointcutParameters createSourcePointcutParameters(Component source, TypedValue<?> attributes) {
        ComponentIdentifier sourceIdentifier = source.getLocation().getComponentIdentifier().getIdentifier();
        SourcePolicyPointcutParametersFactory found = null;
        for (SourcePolicyPointcutParametersFactory factory : this.sourcePointcutFactories) {
            if (!factory.supportsSourceIdentifier(sourceIdentifier)) continue;
            if (found != null) {
                this.throwMoreThanOneFactoryFoundException(sourceIdentifier, SourcePolicyPointcutParametersFactory.class);
            }
            found = factory;
        }
        return found != null ? found.createPolicyPointcutParameters(source, attributes) : new PolicyPointcutParameters(source);
    }

    public PolicyPointcutParameters createOperationPointcutParameters(Component operation, CoreEvent event, Map<String, Object> operationParameters) {
        ComponentIdentifier operationIdentifier = operation.getLocation().getComponentIdentifier().getIdentifier();
        OperationPolicyPointcutParametersFactory found = null;
        for (OperationPolicyPointcutParametersFactory factory : this.operationPointcutFactories) {
            if (!factory.supportsOperationIdentifier(operationIdentifier)) continue;
            if (found != null) {
                this.throwMoreThanOneFactoryFoundException(operationIdentifier, OperationPolicyPointcutParametersFactory.class);
            }
            found = factory;
        }
        PolicyPointcutParameters sourceParameters = (PolicyPointcutParameters)((InternalEvent)event).getInternalParameter(POLICY_SOURCE_POINTCUT_PARAMETERS);
        if (found != null) {
            try {
                return found.createPolicyPointcutParameters(operation, operationParameters, sourceParameters);
            }
            catch (AbstractMethodError error) {
                return found.createPolicyPointcutParameters(operation, operationParameters);
            }
        }
        return new PolicyPointcutParameters(operation, sourceParameters);
    }

    private void throwMoreThanOneFactoryFoundException(ComponentIdentifier sourceIdentifier, Class factoryClass) {
        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("More than one %s for component %s was found. There should be only one.", factoryClass.getName(), sourceIdentifier)));
    }
}

