/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.simple;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.activation.MimetypesFileTypeMap;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.privileged.processor.simple.SimpleMessageProcessor;

public class ParseTemplateProcessor
extends SimpleMessageProcessor {
    private static final MimetypesFileTypeMap mimetypesFileTypeMap = new MimetypesFileTypeMap();
    private String content;
    private MediaType outputMimeType;
    private Charset outputEncoding;
    private String target;
    private String location;
    private String targetValue;

    public void initialise() throws InitialisationException {
        if (this.content != null && this.location != null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Can't define both location and content at the same time"), (Initialisable)this);
        }
        if (this.content == null && this.location == null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"One of 'location' or 'content' should be defined but they are both null"), (Initialisable)this);
        }
        if (this.location != null) {
            this.loadContentFromLocation();
            if (this.outputMimeType == null) {
                this.guessMimeType();
            }
        }
    }

    private void loadContentFromLocation() throws InitialisationException {
        InputStream contentStream;
        try {
            contentStream = IOUtils.getResourceAsStream(this.location, this.getClass());
        }
        catch (IOException e) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Error loading template from location"), (Initialisable)this);
        }
        if (contentStream == null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)("Template location: " + this.location + " not found")), (Initialisable)this);
        }
        this.content = this.outputEncoding != null ? IOUtils.toString(contentStream, this.outputEncoding) : IOUtils.toString(contentStream);
    }

    private void guessMimeType() {
        MediaType fromLocationMediaType = MediaType.parse((String)mimetypesFileTypeMap.getContentType(this.location));
        if (!MediaType.BINARY.equals((Object)fromLocationMediaType)) {
            this.outputMimeType = fromLocationMediaType;
        }
    }

    private void evaluateCorrectArguments() {
        if (this.targetValue != null && this.target == null) {
            throw new IllegalArgumentException("Can't define a targetValue with no target");
        }
    }

    private MediaType buildMediaType() {
        if (this.outputMimeType != null) {
            if (this.outputEncoding != null) {
                return MediaType.create((String)this.outputMimeType.getPrimaryType(), (String)this.outputMimeType.getSubType(), (Charset)this.outputEncoding);
            }
            return this.outputMimeType;
        }
        return null;
    }

    @Override
    public CoreEvent process(CoreEvent event) {
        this.evaluateCorrectArguments();
        String result = this.muleContext.getExpressionManager().parseLogTemplate(this.content, event, this.getLocation(), BindingContextUtils.NULL_BINDING_CONTEXT);
        Message.Builder messageBuilder = Message.builder((Message)event.getMessage()).value((Object)result).nullAttributesValue();
        MediaType configuredMediaType = this.buildMediaType();
        if (configuredMediaType != null) {
            messageBuilder.mediaType(configuredMediaType);
        }
        Message resultMessage = messageBuilder.build();
        if (this.target == null) {
            return CoreEvent.builder(event).message(resultMessage).build();
        }
        if (this.targetValue == null) {
            return CoreEvent.builder(event).addVariable(this.target, resultMessage).build();
        }
        return CoreEvent.builder(event).addVariable(this.target, this.muleContext.getExpressionManager().evaluate(this.targetValue, CoreEvent.builder(event).message(resultMessage).build())).build();
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setTargetValue(String targetValue) {
        this.targetValue = targetValue;
    }

    public void setOutputMimeType(String outputMimeType) {
        this.outputMimeType = MediaType.parse((String)outputMimeType);
    }

    public void setOutputEncoding(String encoding) {
        this.outputEncoding = Charset.forName(encoding);
    }
}

