/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Sink;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.internal.context.thread.notification.ThreadLoggingExecutorServiceDecorator;
import org.mule.runtime.core.internal.processor.strategy.AbstractProcessingStrategy;
import org.mule.runtime.core.internal.processor.strategy.AbstractStreamProcessingStrategyFactory;
import org.mule.runtime.core.internal.processor.strategy.ProactorStreamProcessingStrategy;
import org.mule.runtime.core.internal.processor.strategy.ReactorStreamProcessingStrategyFactory;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.EmitterProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class ProactorStreamEmitterProcessingStrategyFactory
extends ReactorStreamProcessingStrategyFactory {
    @Override
    public ProcessingStrategy create(MuleContext muleContext, String schedulersNamePrefix) {
        return new ProactorStreamEmitterProcessingStrategy(this.getBufferSize(), this.getSubscriberCount(), this.getCpuLightSchedulerSupplier(muleContext, schedulersNamePrefix), () -> muleContext.getSchedulerService().ioScheduler(muleContext.getSchedulerBaseConfig().withName(schedulersNamePrefix + "." + ReactiveProcessor.ProcessingType.BLOCKING.name())), () -> muleContext.getSchedulerService().cpuIntensiveScheduler(muleContext.getSchedulerBaseConfig().withName(schedulersNamePrefix + "." + ReactiveProcessor.ProcessingType.CPU_INTENSIVE.name())), this.resolveParallelism(), this.getMaxConcurrency(), this.isMaxConcurrencyEagerCheck(), muleContext.getConfiguration().isThreadLoggingEnabled());
    }

    @Override
    protected int resolveParallelism() {
        return Integer.max(CORES, this.getMaxConcurrency());
    }

    @Override
    public Class<? extends ProcessingStrategy> getProcessingStrategyType() {
        return ProactorStreamEmitterProcessingStrategy.class;
    }

    static class RoundRobinReactorSink<E>
    implements AbstractProcessingStrategy.ReactorSink<E> {
        private final List<AbstractProcessingStrategy.ReactorSink<E>> fluxSinks;
        private final AtomicInteger index = new AtomicInteger(0);
        private final IntUnaryOperator update;

        public RoundRobinReactorSink(List<AbstractProcessingStrategy.ReactorSink<E>> sinks) {
            this.fluxSinks = sinks;
            this.update = value -> (value + 1) % this.fluxSinks.size();
        }

        public void dispose() {
            this.fluxSinks.stream().forEach(sink -> sink.dispose());
        }

        @Override
        public void accept(CoreEvent event) {
            this.fluxSinks.get(this.nextIndex()).accept(event);
        }

        private int nextIndex() {
            return this.index.getAndUpdate(this.update);
        }

        @Override
        public boolean emit(CoreEvent event) {
            return this.fluxSinks.get(this.nextIndex()).emit(event);
        }

        @Override
        public E intoSink(CoreEvent event) {
            return (E)event;
        }
    }

    static class ProactorStreamEmitterProcessingStrategy
    extends ProactorStreamProcessingStrategy {
        private static Logger LOGGER = LoggerFactory.getLogger(ProactorStreamEmitterProcessingStrategy.class);
        private final int bufferSize;
        private final boolean isThreadLoggingEnabled;

        public ProactorStreamEmitterProcessingStrategy(int bufferSize, int subscriberCount, Supplier<org.mule.runtime.api.scheduler.Scheduler> cpuLightSchedulerSupplier, Supplier<org.mule.runtime.api.scheduler.Scheduler> blockingSchedulerSupplier, Supplier<org.mule.runtime.api.scheduler.Scheduler> cpuIntensiveSchedulerSupplier, int parallelism, int maxConcurrency, boolean maxConcurrencyEagerCheck, boolean isThreadLoggingEnabled) {
            super(subscriberCount, cpuLightSchedulerSupplier, blockingSchedulerSupplier, cpuIntensiveSchedulerSupplier, parallelism, maxConcurrency, maxConcurrencyEagerCheck);
            this.bufferSize = Objects.requireNonNull(bufferSize);
            this.isThreadLoggingEnabled = isThreadLoggingEnabled;
        }

        public ProactorStreamEmitterProcessingStrategy(int bufferSize, int subscriberCount, Supplier<org.mule.runtime.api.scheduler.Scheduler> cpuLightSchedulerSupplier, Supplier<org.mule.runtime.api.scheduler.Scheduler> blockingSchedulerSupplier, Supplier<org.mule.runtime.api.scheduler.Scheduler> cpuIntensiveSchedulerSupplier, int parallelism, int maxConcurrency, boolean maxConcurrencyEagerCheck) {
            this(bufferSize, subscriberCount, cpuLightSchedulerSupplier, blockingSchedulerSupplier, cpuIntensiveSchedulerSupplier, parallelism, maxConcurrency, maxConcurrencyEagerCheck, false);
        }

        @Override
        public Sink createSink(FlowConstruct flowConstruct, ReactiveProcessor function) {
            long shutdownTimeout = flowConstruct.getMuleContext().getConfiguration().getShutdownTimeout();
            int sinksCount = this.maxConcurrency < AbstractStreamProcessingStrategyFactory.CORES ? this.maxConcurrency : AbstractStreamProcessingStrategyFactory.CORES;
            int sinkBufferSize = this.bufferSize / sinksCount;
            ArrayList sinks = new ArrayList();
            for (int i = 0; i < sinksCount; ++i) {
                Latch completionLatch = new Latch();
                EmitterProcessor processor = EmitterProcessor.create((int)sinkBufferSize);
                processor.transform((Function)function).subscribe(null, e -> completionLatch.release(), () -> completionLatch.release());
                AbstractProcessingStrategy.DefaultReactorSink sink = new AbstractProcessingStrategy.DefaultReactorSink(processor.sink(FluxSink.OverflowStrategy.BUFFER), () -> this.awaitSubscribersCompletion(flowConstruct, shutdownTimeout, (CountDownLatch)completionLatch, System.currentTimeMillis()), this.createOnEventConsumer(), sinkBufferSize);
                sinks.add(new ProactorStreamProcessingStrategy.ProactorSinkWrapper(this, sink));
            }
            return new RoundRobinReactorSink(sinks);
        }

        @Override
        public ReactiveProcessor onPipeline(ReactiveProcessor pipeline) {
            Scheduler scheduler = Schedulers.fromExecutorService((ExecutorService)this.decorateScheduler(this.getCpuLightScheduler()));
            return publisher -> Flux.from((Publisher)publisher).publishOn(scheduler).doOnSubscribe(subscription -> Thread.currentThread().setContextClassLoader(this.executionClassloader)).transform((Function)pipeline);
        }

        @Override
        protected Flux<CoreEvent> scheduleProcessor(ReactiveProcessor processor, org.mule.runtime.api.scheduler.Scheduler processorScheduler, CoreEvent event) {
            return this.scheduleWithLogging(processor, processorScheduler, event);
        }

        private Flux<CoreEvent> scheduleWithLogging(ReactiveProcessor processor, org.mule.runtime.api.scheduler.Scheduler processorScheduler, CoreEvent event) {
            if (this.isThreadLoggingEnabled) {
                return Flux.just((Object)event).flatMap(e -> Mono.subscriberContext().flatMap(ctx -> Mono.just((Object)e).transform((Function)processor).subscribeOn(Schedulers.fromExecutorService((ExecutorService)new ThreadLoggingExecutorServiceDecorator(ctx.getOrEmpty((Object)"mule.nb.ThreadNotificationLogger"), this.decorateScheduler(processorScheduler), e.getContext().getId())))));
            }
            return Flux.just((Object)event).transform((Function)processor).subscribeOn(Schedulers.fromExecutorService((ExecutorService)this.decorateScheduler(processorScheduler)));
        }
    }
}

