/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.streaming.object.CursorIterator;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;
import org.mule.runtime.core.internal.streaming.ManagedCursorProvider;
import org.mule.runtime.core.internal.streaming.MutableStreamingStatistics;
import org.mule.runtime.core.internal.streaming.StreamingGhostBuster;
import org.mule.runtime.core.internal.streaming.bytes.ManagedCursorStreamProvider;
import org.mule.runtime.core.internal.streaming.object.ManagedCursorIteratorProvider;
import org.mule.runtime.core.privileged.event.BaseEventContext;

public class CursorManager {
    private final LoadingCache<BaseEventContext, EventStreamingState> registry = Caffeine.newBuilder().removalListener((context, state, cause) -> EventStreamingState.access$300((EventStreamingState)state)).build(context -> {
        this.hookEventTermination((BaseEventContext)context);
        return new EventStreamingState();
    });
    private final MutableStreamingStatistics statistics;
    private final StreamingGhostBuster ghostBuster;

    public CursorManager(MutableStreamingStatistics statistics, StreamingGhostBuster ghostBuster) {
        this.statistics = statistics;
        this.ghostBuster = ghostBuster;
    }

    public CursorProvider manage(CursorProvider provider, BaseEventContext ownerContext) {
        ManagedCursorProvider managedProvider;
        if (provider instanceof CursorStreamProvider) {
            managedProvider = new ManagedCursorStreamProvider((CursorProvider<CursorStream>)provider, this.statistics);
        } else if (provider instanceof CursorIteratorProvider) {
            managedProvider = new ManagedCursorIteratorProvider((CursorProvider<CursorIterator>)provider, this.statistics);
        } else {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Unknown cursor provider type: " + provider.getClass().getName())));
        }
        ((EventStreamingState)this.registry.get((Object)ownerContext)).addProvider(managedProvider);
        return managedProvider;
    }

    private void terminated(BaseEventContext context) {
        this.registry.invalidate((Object)context);
    }

    private void hookEventTermination(BaseEventContext ownerContext) {
        ownerContext.onTerminated((response, throwable) -> this.terminated(ownerContext));
    }

    private class EventStreamingState {
        private final AtomicBoolean disposed = new AtomicBoolean(false);
        private final Set<WeakReference<ManagedCursorProvider>> providers = Collections.newSetFromMap(new ConcurrentHashMap());

        private EventStreamingState() {
        }

        private void addProvider(ManagedCursorProvider provider) {
            this.providers.add(CursorManager.this.ghostBuster.track(provider));
        }

        private void dispose() {
            if (this.disposed.compareAndSet(false, true)) {
                this.providers.forEach(weakReference -> {
                    ManagedCursorProvider provider = (ManagedCursorProvider)weakReference.get();
                    if (provider != null) {
                        weakReference.clear();
                        provider.releaseResources();
                    }
                });
            }
        }
    }
}

