/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.mediatype;

import java.nio.charset.Charset;
import java.util.Optional;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.internal.util.mediatype.MediaTypeDecoratedResult;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class PayloadMediaTypeResolver {
    private Charset defaultEncoding;
    private MediaType defaultMediaType;
    private Optional<Charset> encoding;
    private Optional<MediaType> mimeType;

    public PayloadMediaTypeResolver(Charset defaultEncoding, MediaType defaultMediaType, Optional<Charset> encoding, Optional<MediaType> mimeType) {
        this.defaultEncoding = defaultEncoding;
        this.defaultMediaType = defaultMediaType;
        this.encoding = encoding;
        this.mimeType = mimeType;
    }

    public Result resolve(Result result) {
        return new MediaTypeDecoratedResult(result, this.resolveMediaType(result));
    }

    private MediaType resolveMediaType(Result result) {
        Charset existingEncoding = this.defaultEncoding;
        MediaType mediaType = result.getMediaType().orElse(this.defaultMediaType);
        if (result.getMediaType().isPresent() && mediaType.getCharset().isPresent()) {
            existingEncoding = (Charset)mediaType.getCharset().get();
        }
        return this.mimeType.orElse(mediaType).withCharset(this.encoding.orElse(existingEncoding));
    }
}

