/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.util.CaseInsensitiveHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TemplateParser {
    public static final String ANT_TEMPLATE_STYLE = "ant";
    public static final String SQUARE_TEMPLATE_STYLE = "square";
    public static final String CURLY_TEMPLATE_STYLE = "curly";
    public static final String WIGGLY_MULE_TEMPLATE_STYLE = "mule";
    private static final String NULL_AS_STRING = "null";
    private static final char START_EXPRESSION = '#';
    private static final char OPEN_EXPRESSION = '[';
    private static final char CLOSE_EXPRESSION = ']';
    private static final String EXPRESSION_NOT_CLOSED_ERROR_MSG = "\tOpened expression (%c) at line %d, column %d is not closed\n";
    private static final String QUOTATION_NOT_CLOSED_ERROR_MSG = "\tQuotation (%c) at line %d, column %d is not closed. Remember to use backslash (\\) if you are trying to use that character as a literal";
    private static final String PARSING_TEMPLATE_ERROR = "Error while parsing template:\n";
    private static final Map<String, PatternInfo> patterns = new HashMap<String, PatternInfo>();
    protected static final Logger logger;
    private final Pattern pattern;
    private final int pre;
    private final int post;
    private final PatternInfo style;

    public static TemplateParser createAntStyleParser() {
        return new TemplateParser(ANT_TEMPLATE_STYLE);
    }

    public static TemplateParser createSquareBracesStyleParser() {
        return new TemplateParser(SQUARE_TEMPLATE_STYLE);
    }

    public static TemplateParser createMuleStyleParser() {
        return new TemplateParser(WIGGLY_MULE_TEMPLATE_STYLE);
    }

    private TemplateParser(String styleName) {
        this.style = patterns.get(styleName);
        if (this.style == null) {
            throw new IllegalArgumentException("Unknown template style: " + styleName);
        }
        this.pattern = this.style.getPattern();
        this.pre = this.style.getPrefix().length();
        this.post = this.style.getSuffix().length();
    }

    public String parse(Map<?, ?> props, String template) {
        return this.parse(props, template, null);
    }

    public String parse(TemplateCallback callback, String template) {
        return this.parse(null, template, callback);
    }

    private String parseMule(Map<?, ?> props, String template, TemplateCallback callback, boolean insideExpression) {
        this.validateBalanceMuleStyle(template);
        boolean lastIsBackSlash = false;
        boolean lastStartedExpression = false;
        boolean inExpression = insideExpression;
        boolean openSingleQuotes = false;
        StringBuilder result = new StringBuilder();
        for (int currentPosition = 0; currentPosition < template.length(); ++currentPosition) {
            char c = template.charAt(currentPosition);
            if (lastStartedExpression && c != '[') {
                result.append('#');
            }
            if (lastStartedExpression && c == '[') {
                inExpression = true;
            }
            if (inExpression && c == ']') {
                inExpression = false;
            }
            if (lastIsBackSlash) {
                if ((!inExpression || c != '\'' && c != '\"') && c != '#') {
                    result.append("\\");
                }
            } else if (c == '\'') {
                boolean bl = openSingleQuotes = !openSingleQuotes;
            }
            if (!(c != '[' || !lastStartedExpression || insideExpression && openSingleQuotes)) {
                int closing = this.closingBracesPosition(template, currentPosition);
                String enclosingTemplate = template.substring(currentPosition + 1, closing);
                Object value = enclosingTemplate;
                if (callback != null) {
                    value = callback.match(enclosingTemplate);
                    value = value == null ? NULL_AS_STRING : this.parseMule(props, this.escapeValue(enclosingTemplate, value.toString()), callback, value.equals(enclosingTemplate));
                }
                result.append(value);
                currentPosition = closing;
            } else if ((c != '#' || lastIsBackSlash) && c != '\\') {
                result.append(c);
            }
            lastStartedExpression = !lastIsBackSlash && c == '#';
            lastIsBackSlash = c == '\\';
        }
        return result.toString();
    }

    private int closingBracesPosition(String template, int startingPosition) {
        int openingBraces = 1;
        boolean lastIsBackSlash = false;
        boolean openSingleQuotes = false;
        for (int i = startingPosition + 1; i < template.length(); ++i) {
            char c = template.charAt(i);
            if (c == ']' && !openSingleQuotes) {
                --openingBraces;
            } else if (c == '[' && !openSingleQuotes) {
                ++openingBraces;
            } else if (!lastIsBackSlash && c == '\'') {
                openSingleQuotes = !openSingleQuotes;
            } else if (lastIsBackSlash || c == '\"') {
                // empty if block
            }
            boolean bl = lastIsBackSlash = c == '\\';
            if (openingBraces != 0) continue;
            return i;
        }
        return -1;
    }

    private String escapeValue(String original, String processed) {
        if (original.contains("#")) {
            return processed;
        }
        return processed.replaceAll("(^|[^\\\\])#", "$1\\\\#");
    }

    protected String parse(Map<?, ?> props, String template, TemplateCallback callback) {
        if (this.styleIs(WIGGLY_MULE_TEMPLATE_STYLE)) {
            return this.parseMule(props, template, callback, false);
        }
        String result = template;
        Map<?, ?> newProps = props;
        if (props != null && !(props instanceof CaseInsensitiveHashMap)) {
            newProps = new CaseInsensitiveHashMap(props);
        }
        Matcher m = this.pattern.matcher(result);
        while (m.find()) {
            Object value = null;
            String match = m.group();
            String propname = match.substring(this.pre, match.length() - this.post);
            if (callback != null) {
                value = callback.match(propname);
                if (value == null) {
                    value = NULL_AS_STRING;
                }
            } else if (newProps != null) {
                value = newProps.get(propname);
            }
            if (value == null) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Value " + propname + " not found in context");
                continue;
            }
            String matchRegex = Pattern.quote(match);
            String valueString = value.toString();
            valueString = this.replaceBackSlash(valueString);
            valueString = this.replaceDollarSign(valueString);
            result = result.replaceAll(matchRegex, valueString);
        }
        return result;
    }

    private boolean styleIs(String style) {
        return this.getStyle().getName().equals(style);
    }

    private Stack<Pair<Character, Pair<Integer, Integer>>> unbalacedCharactersMuleStyle(String template) {
        Stack<Pair<Character, Pair<Integer, Integer>>> stack = new Stack<Pair<Character, Pair<Integer, Integer>>>();
        boolean lastStartedExpression = false;
        boolean lastIsBackSlash = false;
        int openBraces = 0;
        int openSingleQuotes = 0;
        int openDoubleQuotes = 0;
        int line = 1;
        int column = 1;
        for (int i = 0; i < template.length(); ++i) {
            char c = template.charAt(i);
            switch (c) {
                case '\'': {
                    if (lastIsBackSlash || openBraces == 0) break;
                    if (!stack.empty() && ((Character)stack.peek().getFirst()).equals(Character.valueOf('\''))) {
                        stack.pop();
                        --openSingleQuotes;
                        break;
                    }
                    stack.push((Pair<Character, Pair<Integer, Integer>>)new Pair((Object)Character.valueOf(c), (Object)new Pair((Object)line, (Object)column)));
                    ++openSingleQuotes;
                    break;
                }
                case '\"': {
                    if (lastIsBackSlash || openBraces == 0) break;
                    if (!stack.empty() && ((Character)stack.peek().getFirst()).equals(Character.valueOf('\"'))) {
                        stack.pop();
                        --openDoubleQuotes;
                        break;
                    }
                    stack.push((Pair<Character, Pair<Integer, Integer>>)new Pair((Object)Character.valueOf(c), (Object)new Pair((Object)line, (Object)column)));
                    ++openDoubleQuotes;
                    break;
                }
                case ']': {
                    if (stack.empty() || !((Character)stack.peek().getFirst()).equals(Character.valueOf('['))) break;
                    stack.pop();
                    --openBraces;
                    break;
                }
                case '[': {
                    if (!lastStartedExpression && openBraces <= 0 || openDoubleQuotes > 0 || openSingleQuotes > 0) break;
                    stack.push((Pair<Character, Pair<Integer, Integer>>)new Pair((Object)Character.valueOf(c), (Object)new Pair((Object)line, (Object)column)));
                    ++openBraces;
                    break;
                }
                case '\n': {
                    ++line;
                    column = 0;
                }
            }
            lastStartedExpression = !lastIsBackSlash && c == '#';
            lastIsBackSlash = c == '\\';
            ++column;
        }
        return stack;
    }

    private void validateBalanceMuleStyle(String template) {
        Stack<Pair<Character, Pair<Integer, Integer>>> remaining = this.unbalacedCharactersMuleStyle(template);
        if (!remaining.empty()) {
            this.throwValidationError(template, remaining);
        }
    }

    private void throwValidationError(String template, Stack<Pair<Character, Pair<Integer, Integer>>> stack) {
        String errorMsg = PARSING_TEMPLATE_ERROR;
        for (Pair pair : stack) {
            char c = ((Character)pair.getFirst()).charValue();
            int line = (Integer)((Pair)pair.getSecond()).getFirst();
            int column = (Integer)((Pair)pair.getSecond()).getSecond();
            String errorType = c == '[' ? EXPRESSION_NOT_CLOSED_ERROR_MSG : QUOTATION_NOT_CLOSED_ERROR_MSG;
            errorMsg = errorMsg + String.format(errorType, Character.valueOf(c), line, column);
        }
        throw new IllegalArgumentException(errorMsg);
    }

    private String replaceDollarSign(String valueString) {
        if (valueString.indexOf(36) != -1) {
            valueString = valueString.replace("$", "\\$");
        }
        return valueString;
    }

    private String replaceBackSlash(String valueString) {
        if (valueString.indexOf("\\") != -1) {
            valueString = valueString.replace("\\", "\\\\");
        }
        return valueString;
    }

    public List<?> parse(Map<?, ?> props, List<?> templates) {
        if (templates == null) {
            return new ArrayList();
        }
        ArrayList list = new ArrayList(templates.size());
        templates.stream().map(tmpl -> this.parse(props, tmpl.toString())).forEach(list::add);
        return list;
    }

    public Map<?, ?> parse(Map<?, ?> props, Map<?, ?> templates) {
        return this.parse((String token) -> props.get(token), templates);
    }

    public Map<?, ?> parse(TemplateCallback callback, Map<?, ?> templates) {
        if (templates == null) {
            return new HashMap();
        }
        HashMap map = new HashMap(templates.size());
        for (Map.Entry<?, ?> entry : templates.entrySet()) {
            map.put(entry.getKey(), this.parse(callback, entry.getValue().toString()));
        }
        return map;
    }

    public PatternInfo getStyle() {
        return this.style;
    }

    public boolean isContainsTemplate(String value) {
        if (value == null) {
            return false;
        }
        Matcher m = this.pattern.matcher(value);
        return m.find();
    }

    public boolean isValid(String expression) {
        if (this.styleIs(WIGGLY_MULE_TEMPLATE_STYLE)) {
            return this.unbalacedCharactersMuleStyle(expression).empty();
        }
        try {
            this.style.validate(expression);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public void validate(String expression) throws IllegalArgumentException {
        this.style.validate(expression);
    }

    static {
        patterns.put(ANT_TEMPLATE_STYLE, new PatternInfo(ANT_TEMPLATE_STYLE, "\\$\\{[^\\{\\}]+\\}", "${", "}"));
        patterns.put(SQUARE_TEMPLATE_STYLE, new PatternInfo(SQUARE_TEMPLATE_STYLE, "\\[[^\\[\\]]+\\]", "[", "]"));
        patterns.put(CURLY_TEMPLATE_STYLE, new PatternInfo(CURLY_TEMPLATE_STYLE, "\\{[^\\{\\}}]+\\}", "{", "}"));
        patterns.put(WIGGLY_MULE_TEMPLATE_STYLE, new PatternInfo(WIGGLY_MULE_TEMPLATE_STYLE, "#\\[((?:#?\\[(?:#?\\[(?:#?\\[(?:#?\\[(?:#?\\[.*?\\]|[^\\[\\]])*?\\]|[^\\[\\]])*?\\]|[^\\[\\]])*?\\]|[^\\[\\]])*?\\]|[^\\[\\]])*?)\\]", "#[", "]"));
        logger = LoggerFactory.getLogger(TemplateParser.class);
    }

    public static class PatternInfo {
        String name;
        String regEx;
        String prefix;
        String suffix;

        PatternInfo(String name, String regEx, String prefix, String suffix) {
            this.name = name;
            this.regEx = regEx;
            if (prefix.length() < 1 || prefix.length() > 2) {
                throw new IllegalArgumentException("Prefix can only be one or two characters long: " + prefix);
            }
            this.prefix = prefix;
            if (suffix.length() != 1) {
                throw new IllegalArgumentException("Suffix can only be one character long: " + suffix);
            }
            this.suffix = suffix;
        }

        public String getRegEx() {
            return this.regEx;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public String getName() {
            return this.name;
        }

        public Pattern getPattern() {
            return Pattern.compile(this.regEx, 2);
        }

        public void validate(String expression) throws IllegalArgumentException {
            int start;
            String currentExpression = expression;
            int lastMatchIdx = 0;
            while (lastMatchIdx < expression.length() && (start = currentExpression.indexOf(this.prefix)) != -1) {
                lastMatchIdx += start;
                currentExpression = currentExpression.substring(start);
                Matcher m = this.getPattern().matcher(currentExpression);
                boolean found = m.find();
                if (found) {
                    if (!currentExpression.startsWith(m.group())) {
                        throw new IllegalArgumentException("Invalid Expression");
                    }
                    int matchSize = m.group().length();
                    lastMatchIdx += matchSize;
                    currentExpression = currentExpression.substring(matchSize);
                    continue;
                }
                throw new IllegalArgumentException("Invalid Expression");
            }
        }
    }

    @FunctionalInterface
    public static interface TemplateCallback {
        public Object match(String var1);
    }
}

