/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.io.parsing;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.parsing.Symbol;
import org.apache.avro.io.parsing.ValidatingGrammarGenerator;
import org.apache.avro.util.internal.Accessor;

public class ResolvingGrammarGenerator
extends ValidatingGrammarGenerator {
    private static EncoderFactory factory;

    public final Symbol generate(Schema writer, Schema reader) throws IOException {
        return Symbol.root(this.generate(writer, reader, new HashMap<ValidatingGrammarGenerator.LitS, Symbol>()));
    }

    private Symbol generate(Schema writer, Schema reader, Map<ValidatingGrammarGenerator.LitS, Symbol> seen) throws IOException {
        block44: {
            Schema.Type readerType;
            Schema.Type writerType;
            block43: {
                writerType = writer.getType();
                if (writerType != (readerType = reader.getType())) break block43;
                switch (writerType) {
                    case NULL: {
                        return Symbol.NULL;
                    }
                    case BOOLEAN: {
                        return Symbol.BOOLEAN;
                    }
                    case INT: {
                        return Symbol.INT;
                    }
                    case LONG: {
                        return Symbol.LONG;
                    }
                    case FLOAT: {
                        return Symbol.FLOAT;
                    }
                    case DOUBLE: {
                        return Symbol.DOUBLE;
                    }
                    case STRING: {
                        return Symbol.STRING;
                    }
                    case BYTES: {
                        return Symbol.BYTES;
                    }
                    case FIXED: {
                        if (writer.getFullName().equals(reader.getFullName()) && writer.getFixedSize() == reader.getFixedSize()) {
                            return Symbol.seq(Symbol.intCheckAction(writer.getFixedSize()), Symbol.FIXED);
                        }
                        break block44;
                    }
                    case ENUM: {
                        if (writer.getFullName() == null || writer.getFullName().equals(reader.getFullName())) {
                            return Symbol.seq(ResolvingGrammarGenerator.mkEnumAdjust(writer.getEnumSymbols(), reader.getEnumSymbols(), reader.getEnumDefault()), Symbol.ENUM);
                        }
                        break block44;
                    }
                    case ARRAY: {
                        return Symbol.seq(Symbol.repeat(Symbol.ARRAY_END, this.generate(writer.getElementType(), reader.getElementType(), seen)), Symbol.ARRAY_START);
                    }
                    case MAP: {
                        return Symbol.seq(Symbol.repeat(Symbol.MAP_END, this.generate(writer.getValueType(), reader.getValueType(), seen), Symbol.STRING), Symbol.MAP_START);
                    }
                    case RECORD: {
                        return this.resolveRecords(writer, reader, seen);
                    }
                    case UNION: {
                        return this.resolveUnion(writer, reader, seen);
                    }
                    default: {
                        throw new AvroTypeException("Unknown type for schema: " + (Object)((Object)writerType));
                    }
                }
            }
            if (writerType == Schema.Type.UNION) {
                return this.resolveUnion(writer, reader, seen);
            }
            switch (readerType) {
                case LONG: {
                    switch (writerType) {
                        case INT: {
                            return Symbol.resolve(super.generate(writer, seen), Symbol.LONG);
                        }
                    }
                    break;
                }
                case FLOAT: {
                    switch (writerType) {
                        case INT: 
                        case LONG: {
                            return Symbol.resolve(super.generate(writer, seen), Symbol.FLOAT);
                        }
                    }
                    break;
                }
                case DOUBLE: {
                    switch (writerType) {
                        case INT: 
                        case LONG: 
                        case FLOAT: {
                            return Symbol.resolve(super.generate(writer, seen), Symbol.DOUBLE);
                        }
                    }
                    break;
                }
                case BYTES: {
                    switch (writerType) {
                        case STRING: {
                            return Symbol.resolve(super.generate(writer, seen), Symbol.BYTES);
                        }
                    }
                    break;
                }
                case STRING: {
                    switch (writerType) {
                        case BYTES: {
                            return Symbol.resolve(super.generate(writer, seen), Symbol.STRING);
                        }
                    }
                    break;
                }
                case UNION: {
                    int j = this.firstMatchingBranch(reader, writer, seen);
                    if (j < 0) break;
                    Symbol s = this.generate(writer, reader.getTypes().get(j), seen);
                    return Symbol.seq(Symbol.unionAdjustAction(j, s), Symbol.UNION);
                }
                case NULL: 
                case BOOLEAN: 
                case INT: 
                case FIXED: 
                case ENUM: 
                case ARRAY: 
                case MAP: 
                case RECORD: {
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected schema type: " + (Object)((Object)readerType));
                }
            }
        }
        return Symbol.error("Found " + writer.getFullName() + ", expecting " + reader.getFullName());
    }

    private Symbol resolveUnion(Schema writer, Schema reader, Map<ValidatingGrammarGenerator.LitS, Symbol> seen) throws IOException {
        boolean needsAdj = !ResolvingGrammarGenerator.unionEquiv(writer, reader, new HashMap<ValidatingGrammarGenerator.LitS, Boolean>());
        List<Schema> alts2 = !needsAdj ? reader.getTypes() : null;
        List<Schema> alts = writer.getTypes();
        int size = alts.size();
        Symbol[] symbols = new Symbol[size];
        String[] labels = new String[size];
        int i = 0;
        for (Schema w : alts) {
            symbols[i] = this.generate(w, needsAdj ? reader : alts2.get(i), seen);
            labels[i] = w.getFullName();
            ++i;
        }
        if (!needsAdj) {
            return Symbol.seq(Symbol.alt(symbols, labels), Symbol.UNION);
        }
        return Symbol.seq(Symbol.alt(symbols, labels), Symbol.WRITER_UNION_ACTION);
    }

    private static boolean unionEquiv(Schema w, Schema r, Map<ValidatingGrammarGenerator.LitS, Boolean> seen) {
        Schema.Type wt = w.getType();
        if (wt != r.getType()) {
            return false;
        }
        if (!(wt != Schema.Type.RECORD && wt != Schema.Type.FIXED && wt != Schema.Type.ENUM || w.getFullName() == null || w.getFullName().equals(r.getFullName()))) {
            return false;
        }
        switch (w.getType()) {
            case NULL: 
            case BOOLEAN: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case BYTES: {
                return true;
            }
            case ARRAY: {
                return ResolvingGrammarGenerator.unionEquiv(w.getElementType(), r.getElementType(), seen);
            }
            case MAP: {
                return ResolvingGrammarGenerator.unionEquiv(w.getValueType(), r.getValueType(), seen);
            }
            case FIXED: {
                return w.getFixedSize() == r.getFixedSize();
            }
            case ENUM: {
                List<String> ws = w.getEnumSymbols();
                List<String> rs = r.getEnumSymbols();
                if (ws.size() != rs.size()) {
                    return false;
                }
                int i = 0;
                for (i = 0; i < ws.size() && ws.get(i).equals(rs.get(i)); ++i) {
                }
                return i == ws.size();
            }
            case UNION: {
                List<Schema> wb = w.getTypes();
                List<Schema> rb = r.getTypes();
                if (wb.size() != rb.size()) {
                    return false;
                }
                int i = 0;
                for (i = 0; i < wb.size() && ResolvingGrammarGenerator.unionEquiv(wb.get(i), rb.get(i), seen); ++i) {
                }
                return i == wb.size();
            }
            case RECORD: {
                LitS2 wsc = new LitS2(w, r);
                if (!seen.containsKey(wsc)) {
                    seen.put(wsc, true);
                    List<Schema.Field> wb = w.getFields();
                    List<Schema.Field> rb = r.getFields();
                    if (wb.size() != rb.size()) {
                        seen.put(wsc, false);
                    } else {
                        int i = 0;
                        for (i = 0; i < wb.size() && ResolvingGrammarGenerator.unionEquiv(wb.get(i).schema(), rb.get(i).schema(), seen); ++i) {
                        }
                        seen.put(wsc, i == wb.size());
                    }
                }
                return seen.get(wsc);
            }
        }
        throw new IllegalArgumentException("Unknown schema type: " + (Object)((Object)w.getType()));
    }

    private Symbol resolveRecords(Schema writer, Schema reader, Map<ValidatingGrammarGenerator.LitS, Symbol> seen) throws IOException {
        LitS2 wsc = new LitS2(writer, reader);
        Symbol result = seen.get(wsc);
        if (result == null) {
            String fname;
            List<Schema.Field> wfields = writer.getFields();
            List<Schema.Field> rfields = reader.getFields();
            Schema.Field[] reordered = new Schema.Field[rfields.size()];
            int ridx = 0;
            int count = 1 + wfields.size();
            for (Schema.Field f : wfields) {
                Schema.Field rdrField = reader.getField(f.name());
                if (rdrField == null) continue;
                reordered[ridx++] = rdrField;
            }
            for (Schema.Field rf : rfields) {
                String fname2 = rf.name();
                if (writer.getField(fname2) != null) continue;
                if (rf.defaultVal() == null) {
                    result = Symbol.error("Found " + writer.getFullName() + ", expecting " + reader.getFullName() + ", missing required field " + fname2);
                    seen.put(wsc, result);
                    return result;
                }
                reordered[ridx++] = rf;
                count += 3;
            }
            Symbol[] production = new Symbol[count];
            production[--count] = Symbol.fieldOrderAction(reordered);
            result = Symbol.seq(production);
            seen.put(wsc, result);
            for (Schema.Field wf : wfields) {
                fname = wf.name();
                Schema.Field rf = reader.getField(fname);
                if (rf == null) {
                    production[--count] = Symbol.skipAction(this.generate(wf.schema(), wf.schema(), seen));
                    continue;
                }
                production[--count] = this.generate(wf.schema(), rf.schema(), seen);
            }
            for (Schema.Field rf : rfields) {
                fname = rf.name();
                Schema.Field wf = writer.getField(fname);
                if (wf != null) continue;
                byte[] bb = ResolvingGrammarGenerator.getBinary(rf.schema(), Accessor.defaultValue(rf));
                production[--count] = Symbol.defaultStartAction(bb);
                production[--count] = this.generate(rf.schema(), rf.schema(), seen);
                production[--count] = Symbol.DEFAULT_END_ACTION;
            }
        }
        return result;
    }

    private static byte[] getBinary(Schema s, JsonNode n) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BinaryEncoder e = factory.binaryEncoder(out, null);
        ResolvingGrammarGenerator.encode(e, s, n);
        e.flush();
        return out.toByteArray();
    }

    static void encode(Encoder e, Schema s, JsonNode n) throws IOException {
        switch (s.getType()) {
            case RECORD: {
                for (Schema.Field f : s.getFields()) {
                    String name = f.name();
                    JsonNode v = n.get(name);
                    if (v == null) {
                        v = Accessor.defaultValue(f);
                    }
                    if (v == null) {
                        throw new AvroTypeException("No default value for: " + name);
                    }
                    ResolvingGrammarGenerator.encode(e, f.schema(), v);
                }
                break;
            }
            case ENUM: {
                e.writeEnum(s.getEnumOrdinal(n.textValue()));
                break;
            }
            case ARRAY: {
                e.writeArrayStart();
                e.setItemCount(n.size());
                Schema i = s.getElementType();
                for (JsonNode node : n) {
                    e.startItem();
                    ResolvingGrammarGenerator.encode(e, i, node);
                }
                e.writeArrayEnd();
                break;
            }
            case MAP: {
                e.writeMapStart();
                e.setItemCount(n.size());
                Schema v = s.getValueType();
                Iterator it = n.fieldNames();
                while (it.hasNext()) {
                    e.startItem();
                    String key = (String)it.next();
                    e.writeString(key);
                    ResolvingGrammarGenerator.encode(e, v, n.get(key));
                }
                e.writeMapEnd();
                break;
            }
            case UNION: {
                e.writeIndex(0);
                ResolvingGrammarGenerator.encode(e, s.getTypes().get(0), n);
                break;
            }
            case FIXED: {
                if (!n.isTextual()) {
                    throw new AvroTypeException("Non-string default value for fixed: " + n);
                }
                byte[] bb = n.textValue().getBytes(StandardCharsets.ISO_8859_1);
                if (bb.length != s.getFixedSize()) {
                    bb = Arrays.copyOf(bb, s.getFixedSize());
                }
                e.writeFixed(bb);
                break;
            }
            case STRING: {
                if (!n.isTextual()) {
                    throw new AvroTypeException("Non-string default value for string: " + n);
                }
                e.writeString(n.textValue());
                break;
            }
            case BYTES: {
                if (!n.isTextual()) {
                    throw new AvroTypeException("Non-string default value for bytes: " + n);
                }
                e.writeBytes(n.textValue().getBytes(StandardCharsets.ISO_8859_1));
                break;
            }
            case INT: {
                if (!n.isNumber()) {
                    throw new AvroTypeException("Non-numeric default value for int: " + n);
                }
                e.writeInt(n.intValue());
                break;
            }
            case LONG: {
                if (!n.isNumber()) {
                    throw new AvroTypeException("Non-numeric default value for long: " + n);
                }
                e.writeLong(n.longValue());
                break;
            }
            case FLOAT: {
                if (!n.isNumber()) {
                    throw new AvroTypeException("Non-numeric default value for float: " + n);
                }
                e.writeFloat((float)n.doubleValue());
                break;
            }
            case DOUBLE: {
                if (!n.isNumber()) {
                    throw new AvroTypeException("Non-numeric default value for double: " + n);
                }
                e.writeDouble(n.doubleValue());
                break;
            }
            case BOOLEAN: {
                if (!n.isBoolean()) {
                    throw new AvroTypeException("Non-boolean default for boolean: " + n);
                }
                e.writeBoolean(n.booleanValue());
                break;
            }
            case NULL: {
                if (!n.isNull()) {
                    throw new AvroTypeException("Non-null default value for null type: " + n);
                }
                e.writeNull();
            }
        }
    }

    private static Symbol mkEnumAdjust(List<String> wsymbols, List<String> rsymbols, Object rEnumDefault) {
        Object[] adjustments = new Object[wsymbols.size()];
        for (int i = 0; i < adjustments.length; ++i) {
            int j = rsymbols.indexOf(wsymbols.get(i));
            if (j == -1 && rEnumDefault instanceof String) {
                j = rsymbols.indexOf(rEnumDefault);
            }
            adjustments[i] = j == -1 ? "No match for " + wsymbols.get(i) : new Integer(j);
        }
        return Symbol.enumAdjustAction(rsymbols.size(), adjustments);
    }

    private boolean hasMatchError(Symbol sym) {
        if (sym instanceof Symbol.ErrorAction) {
            return true;
        }
        for (int i = 0; i < sym.production.length; ++i) {
            if (!(sym.production[i] instanceof Symbol.ErrorAction)) continue;
            return true;
        }
        return false;
    }

    private int firstMatchingBranch(Schema r, Schema w, Map<ValidatingGrammarGenerator.LitS, Symbol> seen) throws IOException {
        Schema.Type vt = w.getType();
        int j = 0;
        int structureMatch = -1;
        for (Schema b : r.getTypes()) {
            if (vt == b.getType()) {
                if (vt == Schema.Type.RECORD || vt == Schema.Type.ENUM || vt == Schema.Type.FIXED) {
                    String vname = w.getFullName();
                    String bname = b.getFullName();
                    if (vname != null && vname.equals(bname)) {
                        return j;
                    }
                    if (vt == Schema.Type.RECORD && !this.hasMatchError(this.resolveRecords(w, b, seen))) {
                        String vShortName = w.getName();
                        String bShortName = b.getName();
                        if (structureMatch < 0 || vShortName != null && vShortName.equals(bShortName)) {
                            structureMatch = j;
                        }
                    }
                } else {
                    return j;
                }
            }
            ++j;
        }
        if (structureMatch >= 0) {
            return structureMatch;
        }
        j = 0;
        for (Schema b : r.getTypes()) {
            switch (vt) {
                case INT: {
                    switch (b.getType()) {
                        case LONG: 
                        case FLOAT: 
                        case DOUBLE: {
                            return j;
                        }
                    }
                    break;
                }
                case LONG: {
                    switch (b.getType()) {
                        case FLOAT: 
                        case DOUBLE: {
                            return j;
                        }
                    }
                    break;
                }
                case FLOAT: {
                    switch (b.getType()) {
                        case DOUBLE: {
                            return j;
                        }
                    }
                    break;
                }
                case STRING: {
                    switch (b.getType()) {
                        case BYTES: {
                            return j;
                        }
                    }
                    break;
                }
                case BYTES: {
                    switch (b.getType()) {
                        case STRING: {
                            return j;
                        }
                    }
                }
            }
            ++j;
        }
        return -1;
    }

    static {
        Accessor.setAccessor(new Accessor.ResolvingGrammarGeneratorAccessor(){

            @Override
            protected void encode(Encoder e, Schema s, JsonNode n) throws IOException {
                ResolvingGrammarGenerator.encode(e, s, n);
            }
        });
        factory = new EncoderFactory().configureBufferSize(32);
    }

    static class LitS2
    extends ValidatingGrammarGenerator.LitS {
        public Schema expected;

        public LitS2(Schema actual, Schema expected) {
            super(actual);
            this.expected = expected;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof LitS2)) {
                return false;
            }
            LitS2 other = (LitS2)o;
            return this.actual == other.actual && this.expected == other.expected;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.expected.hashCode();
        }
    }
}

