/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.maven;

import com.vdurmont.semver4j.Semver;
import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Plugin;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleScope;
import org.mule.runtime.module.deployment.impl.internal.maven.ArtifactClassLoaderModelBuilder;
import org.mule.tools.api.classloader.model.AppClassLoaderModel;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ClassLoaderModel;

public class HeavyweightClassLoaderModelBuilder
extends ArtifactClassLoaderModelBuilder {
    private static final Semver CLASS_LOADER_MODEL_VERSION_110 = new Semver("1.1.0", Semver.SemverType.LOOSE);
    private ClassLoaderModel packagerClassLoaderModel;

    public HeavyweightClassLoaderModelBuilder(File applicationFolder, BundleDescriptor artifactBundleDescriptor, ClassLoaderModel packagerClassLoaderModel) {
        super(applicationFolder, artifactBundleDescriptor);
        this.packagerClassLoaderModel = packagerClassLoaderModel;
    }

    @Override
    protected void doExportSharedLibrariesResourcesAndPackages(Plugin packagingPlugin) {
        if (new Semver(this.packagerClassLoaderModel.getVersion(), Semver.SemverType.LOOSE).isLowerThan(CLASS_LOADER_MODEL_VERSION_110)) {
            super.doExportSharedLibrariesResourcesAndPackages(packagingPlugin);
        } else {
            this.exportSharedLibrariesResourcesAndPackages();
        }
    }

    @Override
    protected Map<BundleDescriptor, Set<BundleDescriptor>> doProcessAdditionalPluginLibraries(Plugin packagingPlugin) {
        if (this.packagerClassLoaderModel instanceof AppClassLoaderModel) {
            AppClassLoaderModel appClassLoaderModel = (AppClassLoaderModel)this.packagerClassLoaderModel;
            appClassLoaderModel.getAdditionalPluginDependencies().ifPresent(additionalDeps -> additionalDeps.forEach(this::updateDependency));
        }
        return Collections.emptyMap();
    }

    @Override
    protected List<URI> processPluginAdditionalDependenciesURIs(BundleDependency bundleDependency) {
        return bundleDependency.getAdditionalDependencies().stream().map(BundleDependency::getBundleUri).collect(Collectors.toList());
    }

    private BundleDependency createExtendedBundleDependency(BundleDependency original, Set<BundleDependency> additionalPluginDependencies) {
        return new BundleDependency.Builder(original).setAdditionalDependencies(additionalPluginDependencies).build();
    }

    private void updateDependency(org.mule.tools.api.classloader.model.Plugin plugin) {
        this.dependencies.stream().filter(dep -> this.areSameDependency(plugin, (BundleDependency)dep)).findFirst().ifPresent(pluginDependency -> this.replaceBundleDependency((BundleDependency)pluginDependency, this.createExtendedBundleDependency((BundleDependency)pluginDependency, plugin.getAdditionalDependencies().stream().map(this::toBundleDependency).collect(Collectors.toSet()))));
    }

    private boolean areSameDependency(org.mule.tools.api.classloader.model.Plugin plugin, BundleDependency dependency) {
        return StringUtils.equals((CharSequence)dependency.getDescriptor().getGroupId(), (CharSequence)plugin.getGroupId()) && StringUtils.equals((CharSequence)dependency.getDescriptor().getArtifactId(), (CharSequence)plugin.getArtifactId());
    }

    private BundleDependency toBundleDependency(Artifact artifact) {
        BundleDependency.Builder builder = new BundleDependency.Builder();
        if (artifact.getArtifactCoordinates().getScope() != null) {
            builder.setScope(BundleScope.valueOf((String)artifact.getArtifactCoordinates().getScope().toUpperCase()));
        }
        return builder.setBundleUri(new File(this.artifactFolder, artifact.getUri().toString()).toURI()).setDescriptor(new BundleDescriptor.Builder().setArtifactId(artifact.getArtifactCoordinates().getArtifactId()).setGroupId(artifact.getArtifactCoordinates().getGroupId()).setVersion(artifact.getArtifactCoordinates().getVersion()).setClassifier(artifact.getArtifactCoordinates().getClassifier()).setType(artifact.getArtifactCoordinates().getType()).build()).build();
    }

    private void exportSharedLibrariesResourcesAndPackages() {
        this.packagerClassLoaderModel.getDependencies().stream().filter(Artifact::isShared).forEach(sharedDep -> this.findAndExportSharedLibrary(sharedDep.getArtifactCoordinates().getGroupId(), sharedDep.getArtifactCoordinates().getArtifactId()));
    }
}

