/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.nodes.snakeyaml;

import com.google.common.collect.EvictingQueue;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.CharBuffer;
import javax.annotation.Nullable;
import org.apache.commons.lang.SystemUtils;
import org.raml.v2.api.loader.DefaultResourceLoader;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.yagi.framework.nodes.DefaultPosition;
import org.raml.yagi.framework.nodes.ErrorNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.snakeyaml.SYModelWrapper;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.error.MarkedYAMLException;
import org.yaml.snakeyaml.reader.ReaderException;
import org.yaml.snakeyaml.reader.StreamReader;

public class NodeParser {
    @Nullable
    public static Node parse(ResourceLoader resourceLoader, String resourcePath, Reader reader) {
        SmartReader smartReader = new SmartReader(reader);
        try {
            Yaml yamlParser = new Yaml();
            org.yaml.snakeyaml.nodes.Node composedNode = yamlParser.compose((Reader)smartReader);
            if (composedNode == null) {
                return null;
            }
            return new SYModelWrapper(resourceLoader, resourcePath).wrap(composedNode);
        }
        catch (MarkedYAMLException e) {
            return NodeParser.buildYamlErrorNode(e, resourcePath);
        }
        catch (ReaderException e) {
            return NodeParser.buildYamlErrorNode(e, smartReader);
        }
    }

    private static Node buildYamlErrorNode(MarkedYAMLException e, String resourcePath) {
        ErrorNode errorNode = new ErrorNode("Underlying error while parsing YAML syntax: '" + e.getMessage() + "'");
        Mark problemMark = e.getProblemMark();
        errorNode.setStartPosition(new DefaultPosition(problemMark.getIndex(), problemMark.getLine(), 0, resourcePath, new DefaultResourceLoader()));
        errorNode.setEndPosition(new DefaultPosition(problemMark.getIndex() + 1, problemMark.getLine(), problemMark.getColumn(), resourcePath, new DefaultResourceLoader()));
        return errorNode;
    }

    private static Node buildYamlErrorNode(ReaderException e, SmartReader reader) {
        ErrorNode errorNode = new ErrorNode("Underlying error while parsing YAML syntax: '" + e.getMessage() + " around: " + reader.getLastValidString() + "'");
        return errorNode;
    }

    @Nullable
    public static Node parse(ResourceLoader resourceLoader, String resourcePath, String content) {
        if (SystemUtils.IS_OS_WINDOWS) {
            content = content.replace("\r\n", "\n");
        }
        return NodeParser.parse(resourceLoader, resourcePath, new StringReader(content));
    }

    static class SmartReader
    extends Reader {
        private final Reader delegate;
        private char[] lastBufferRead;
        private int lastBufferSize;

        public SmartReader(Reader delegate) {
            this.delegate = delegate;
        }

        @Override
        public int read(CharBuffer target) throws IOException {
            return this.delegate.read(target);
        }

        @Override
        public int read() throws IOException {
            return this.delegate.read();
        }

        @Override
        public int read(char[] cbuf) throws IOException {
            try {
                int numberOfRead = this.delegate.read(cbuf);
                this.lastBufferRead = cbuf;
                this.lastBufferSize = numberOfRead;
                return numberOfRead;
            }
            catch (IOException e) {
                this.lastBufferSize = 0;
                throw e;
            }
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            return this.delegate.read(cbuf, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        @Override
        public boolean ready() throws IOException {
            return this.delegate.ready();
        }

        @Override
        public boolean markSupported() {
            return this.delegate.markSupported();
        }

        @Override
        public void mark(int readAheadLimit) throws IOException {
            this.delegate.mark(readAheadLimit);
        }

        @Override
        public void reset() throws IOException {
            this.delegate.reset();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        public String getLastValidString() {
            EvictingQueue seen = EvictingQueue.create((int)64);
            for (int i = 0; i < this.lastBufferSize; ++i) {
                if (!StreamReader.isPrintable((char)this.lastBufferRead[i])) {
                    for (char c : ("[BAD: " + this.lastBufferRead[i] + "]").toCharArray()) {
                        seen.add((Object)Character.valueOf(c));
                    }
                    break;
                }
                seen.add((Object)Character.valueOf(this.lastBufferRead[i]));
            }
            Character[] foo = (Character[])seen.toArray((Object[])new Character[0]);
            StringBuilder sb = new StringBuilder();
            for (Character character : foo) {
                sb.append(character);
            }
            return sb.toString();
        }
    }
}

