/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.PoolingConnectionProvider;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.connection.ConnectionManagementType;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.DeclaresExternalLibraries;
import org.mule.runtime.api.meta.model.declaration.fluent.HasConnectionProviderDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasParametersDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NamedDeclaration;
import org.mule.runtime.extension.api.annotation.connectivity.oauth.AuthorizationCode;
import org.mule.runtime.extension.api.connectivity.NoConnectivityTest;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthModelProperty;
import org.mule.runtime.extension.api.exception.IllegalConnectionProviderModelDefinitionException;
import org.mule.runtime.module.extension.api.loader.java.type.ConnectionProviderElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.api.loader.java.type.WithConnectionProviders;
import org.mule.runtime.module.extension.internal.loader.java.AbstractModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.DefaultConnectionProviderFactory;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.property.ConnectionProviderFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ConnectionTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.utils.ParameterDeclarationContext;

final class ConnectionProviderModelLoaderDelegate
extends AbstractModelLoaderDelegate {
    private static final String CONNECTION_PROVIDER = "Connection Provider";
    private final Map<ConnectionProviderElement, ConnectionProviderDeclarer> connectionProviderDeclarers = new HashMap<ConnectionProviderElement, ConnectionProviderDeclarer>();

    ConnectionProviderModelLoaderDelegate(DefaultJavaModelLoaderDelegate loader) {
        super(loader);
    }

    void declareConnectionProviders(HasConnectionProviderDeclarer declarer, WithConnectionProviders withConnectionProviders) {
        withConnectionProviders.getConnectionProviders().forEach(provider -> this.declareConnectionProvider(declarer, (ConnectionProviderElement)provider));
    }

    private void declareConnectionProvider(HasConnectionProviderDeclarer declarer, ConnectionProviderElement providerType) {
        List<Type> providerGenerics;
        ConnectionProviderDeclarer providerDeclarer = this.connectionProviderDeclarers.get(providerType);
        if (providerDeclarer != null) {
            declarer.withConnectionProvider(providerDeclarer);
            return;
        }
        String name = providerType.getAlias();
        String description = providerType.getDescription();
        if (providerType.getName().equals(providerType.getAlias())) {
            name = "connection";
        }
        if ((providerGenerics = providerType.getSuperTypeGenerics(ConnectionProvider.class)).size() != 1) {
            throw new IllegalConnectionProviderModelDefinitionException(String.format("Connection provider class '%s' was expected to have 1 generic type (for the connection type) but %d were found", providerType.getName(), providerGenerics.size()));
        }
        ConnectionProviderDeclarer finalProviderDeclarer = providerDeclarer = declarer.withConnectionProvider(name).describedAs(description);
        providerType.getDeclaringClass().ifPresent(clazz -> finalProviderDeclarer.withModelProperty((ModelProperty)new ConnectionProviderFactoryModelProperty(new DefaultConnectionProviderFactory((Class<?>)clazz, this.getExtensionClassLoader()))).withModelProperty((ModelProperty)new ImplementingTypeModelProperty((Class<?>)clazz)));
        providerDeclarer.withModelProperty((ModelProperty)new ConnectionTypeModelProperty(providerGenerics.get(0))).withModelProperty((ModelProperty)new ExtensionTypeDescriptorModelProperty(providerType));
        this.loader.parseExternalLibs(providerType, (DeclaresExternalLibraries)providerDeclarer);
        ConnectionManagementType managementType = ConnectionManagementType.NONE;
        if (providerType.isAssignableTo(PoolingConnectionProvider.class)) {
            managementType = ConnectionManagementType.POOLING;
        } else if (providerType.isAssignableTo(CachedConnectionProvider.class)) {
            managementType = ConnectionManagementType.CACHED;
        }
        this.parseOAuthGrantType(providerType, providerDeclarer);
        providerDeclarer.withConnectionManagementType(managementType);
        providerDeclarer.supportsConnectivityTesting(!providerType.isAssignableTo(NoConnectivityTest.class));
        this.connectionProviderDeclarers.put(providerType, providerDeclarer);
        ParameterDeclarationContext context = new ParameterDeclarationContext(CONNECTION_PROVIDER, (NamedDeclaration)providerDeclarer.getDeclaration());
        this.loader.getFieldParametersLoader().declare((HasParametersDeclarer)providerDeclarer, providerType.getParameters(), context);
    }

    private void parseOAuthGrantType(ConnectionProviderElement providerType, ConnectionProviderDeclarer providerDeclarer) {
        providerType.getAnnotation(AuthorizationCode.class).ifPresent(a -> {
            AuthorizationCodeGrantType grantType = new AuthorizationCodeGrantType(a.accessTokenUrl(), a.authorizationUrl(), a.accessTokenExpr(), a.expirationExpr(), a.refreshTokenExpr(), a.defaultScopes());
            providerDeclarer.withModelProperty((ModelProperty)new OAuthModelProperty(Arrays.asList(grantType)));
        });
    }
}

