/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.io;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.reflect.io.Path;
import scala.reflect.io.Path$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

public final class FileHelper$ {
    public static FileHelper$ MODULE$;
    private File tmpdir;
    private final Logger org$mule$weave$v2$io$FileHelper$$logger;
    private final AtomicLong counter;
    private final ExecutorService scheduler;
    private volatile boolean bitmap$0;

    static {
        new FileHelper$();
    }

    public Logger org$mule$weave$v2$io$FileHelper$$logger() {
        return this.org$mule$weave$v2$io$FileHelper$$logger;
    }

    public String tmpFilePath() {
        return System.getProperty("java.io.tmpdir");
    }

    private File tmpdir$lzycompute() {
        FileHelper$ fileHelper$ = this;
        synchronized (fileHelper$) {
            if (!this.bitmap$0) {
                this.tmpdir = new File(this.tmpFilePath());
                this.bitmap$0 = true;
            }
        }
        return this.tmpdir;
    }

    public File tmpdir() {
        return !this.bitmap$0 ? this.tmpdir$lzycompute() : this.tmpdir;
    }

    private AtomicLong counter() {
        return this.counter;
    }

    private ExecutorService scheduler() {
        return this.scheduler;
    }

    public File createTempFile(String prefix, String suffix) {
        long n = this.counter().getAndIncrement();
        n = n == Long.MIN_VALUE ? 0L : Math.abs(n);
        if (!this.tmpdir().exists()) {
            throw new RuntimeException(new StringBuilder(106).append("The specified temporary ").append(this.tmpdir().getAbsolutePath()).append(" directory does not exits. Please create the directory or provide a different one.").toString());
        }
        File result = new File(this.tmpdir(), new StringBuilder(0).append(prefix).append(n).append(suffix).toString());
        while (result.exists()) {
            n = this.counter().getAndIncrement();
            result = new File(this.tmpdir(), new StringBuilder(0).append(prefix).append(n).append(suffix).toString());
        }
        return result;
    }

    public void deleteAsync(File tmp) {
        this.scheduler().submit(new Runnable(tmp){
            private final File tmp$1;

            public void run() {
                block0: {
                    boolean deleted;
                    if (!this.tmp$1.exists() || (deleted = this.tmp$1.delete()) || !this.tmp$1.exists()) break block0;
                    FileHelper$.MODULE$.org$mule$weave$v2$io$FileHelper$$logger().log(Level.WARNING, new StringBuilder(55).append("Unable to async delete ").append(this.tmp$1.getAbsolutePath()).append(", it may be locked someone else.").toString());
                }
            }
            {
                this.tmp$1 = tmp$1;
            }
        });
    }

    public void deleteDirectory(File folder) {
        Path path = Path$.MODULE$.apply(folder);
        Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> path.deleteRecursively());
    }

    public String baseName(File x) {
        String fileName = x.getName();
        return x.isDirectory() ? fileName : this.baseName(fileName);
    }

    public String baseName(String fileName) {
        return fileName.contains(".") ? fileName.substring(0, fileName.lastIndexOf(".")) : fileName;
    }

    public String getExtension(File output) {
        String name = output.getName();
        return (String)this.getExtension(name).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
    }

    public Option<String> getExtension(String name) {
        return name.lastIndexOf(46) >= 0 ? new Some(new StringOps(Predef$.MODULE$.augmentString(name)).drop(name.lastIndexOf(46))) : None$.MODULE$;
    }

    public File createBufferFile(String name) {
        return this.createTempFile(new StringBuilder(11).append("dw-buffer-").append(name).append("-").toString(), ".tmp");
    }

    private FileHelper$() {
        MODULE$ = this;
        this.org$mule$weave$v2$io$FileHelper$$logger = Logger.getLogger(this.getClass().getName());
        this.counter = new AtomicLong(1L);
        this.scheduler = Executors.newFixedThreadPool(10, new ThreadFactory(){
            private final AtomicLong counter;

            private AtomicLong counter() {
                return this.counter;
            }

            /*
             * WARNING - void declaration
             */
            public Thread newThread(Runnable r) {
                void var2_2;
                Thread thread = new Thread(r, new StringBuilder(19).append("Weave_File_Deleter_").append(this.counter().getAndDecrement()).toString());
                thread.setDaemon(true);
                return var2_2;
            }
            {
                this.counter = new AtomicLong(1L);
            }
        });
    }
}

