/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.el;

import java.util.Iterator;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionExecutionException;
import org.mule.runtime.api.el.ExpressionLanguageSession;
import org.mule.runtime.api.el.ValidationResult;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;

public interface ExpressionLanguage {
    public void addGlobalBindings(BindingContext var1);

    public TypedValue<?> evaluate(String var1, BindingContext var2) throws ExpressionExecutionException;

    public TypedValue<?> evaluate(String var1, DataType var2, BindingContext var3) throws ExpressionExecutionException;

    public TypedValue<?> evaluateLogExpression(String var1, BindingContext var2) throws ExpressionExecutionException;

    public ValidationResult validate(String var1);

    public Iterator<TypedValue<?>> split(String var1, BindingContext var2);

    default public ExpressionLanguageSession openSession(final BindingContext context) {
        final ExpressionLanguage expressionLanguage = this;
        return new ExpressionLanguageSession(){

            @Override
            public TypedValue<?> evaluate(String expression) throws ExpressionExecutionException {
                return expressionLanguage.evaluate(expression, context);
            }

            @Override
            public TypedValue<?> evaluate(String expression, DataType expectedOutputType) throws ExpressionExecutionException {
                return expressionLanguage.evaluate(expression, expectedOutputType, context);
            }

            @Override
            public TypedValue<?> evaluate(String expression, long timeout) throws ExpressionExecutionException {
                return expressionLanguage.evaluate(expression, context);
            }

            @Override
            public TypedValue<?> evaluateLogExpression(String expression) throws ExpressionExecutionException {
                return expressionLanguage.evaluateLogExpression(expression, context);
            }

            @Override
            public Iterator<TypedValue<?>> split(String expression) {
                return expressionLanguage.split(expression, context);
            }

            @Override
            public void close() {
            }
        };
    }
}

