/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.config;

import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.time.TimeSupplier;
import org.mule.runtime.core.internal.time.LocalTimeSupplier;
import org.mule.runtime.extension.api.ExtensionConstants;
import org.mule.runtime.extension.api.runtime.ExpirationPolicy;

public final class ImmutableExpirationPolicy
extends AbstractComponent
implements ExpirationPolicy {
    private final long maxIdleTime;
    private final TimeUnit timeUnit;
    private final TimeSupplier timeSupplier;

    public static ExpirationPolicy getDefault() {
        return ImmutableExpirationPolicy.getDefault(new LocalTimeSupplier());
    }

    public static ExpirationPolicy getDefault(TimeSupplier timeSupplier) {
        return new ImmutableExpirationPolicy(ExtensionConstants.DYNAMIC_CONFIG_EXPIRATION_FREQUENCY.getTime(), ExtensionConstants.DYNAMIC_CONFIG_EXPIRATION_FREQUENCY.getUnit(), timeSupplier);
    }

    public ImmutableExpirationPolicy(long maxIdleTime, TimeUnit timeUnit, TimeSupplier timeSupplier) {
        this.maxIdleTime = maxIdleTime;
        this.timeUnit = timeUnit;
        this.timeSupplier = timeSupplier;
    }

    public boolean isExpired(long lastUsed, TimeUnit timeUnit) {
        long idleTimeMillis = this.timeSupplier.get() - timeUnit.toMillis(lastUsed);
        return idleTimeMillis > this.timeUnit.toMillis(this.maxIdleTime);
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }
}

