/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.policy.Policy;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public abstract class AbstractCompositePolicy<ParametersTransformer> {
    private final List<Policy> parameterizedPolicies;
    private final Optional<ParametersTransformer> parametersTransformer;
    private final ReactiveProcessor executionProcessor;

    public AbstractCompositePolicy(List<Policy> policies, Optional<ParametersTransformer> parametersTransformer) {
        Preconditions.checkArgument((!policies.isEmpty() ? 1 : 0) != 0, (String)"policies list cannot be empty");
        this.parameterizedPolicies = policies;
        this.parametersTransformer = parametersTransformer;
        this.executionProcessor = this.getPolicyProcessor();
    }

    private ReactiveProcessor getPolicyProcessor() {
        ArrayList<Function<ReactiveProcessor, ReactiveProcessor>> interceptors = new ArrayList<Function<ReactiveProcessor, ReactiveProcessor>>();
        for (Policy policy : this.parameterizedPolicies) {
            interceptors.add(next -> eventPub -> Flux.from(this.applyPolicy(policy, (ReactiveProcessor)next, (Publisher<CoreEvent>)eventPub)));
        }
        Policy lastPolicy = this.parameterizedPolicies.get(this.parameterizedPolicies.size() - 1);
        ReactiveProcessor chainedPoliciesAndOperation = eventPub -> Flux.from(this.applyNextOperation((Publisher<CoreEvent>)eventPub, lastPolicy));
        Collections.reverse(interceptors);
        for (Function function : interceptors) {
            chainedPoliciesAndOperation = (ReactiveProcessor)function.apply(chainedPoliciesAndOperation);
        }
        return chainedPoliciesAndOperation;
    }

    protected Optional<ParametersTransformer> getParametersTransformer() {
        return this.parametersTransformer;
    }

    protected ReactiveProcessor getExecutionProcessor() {
        return this.executionProcessor;
    }

    protected abstract Publisher<CoreEvent> applyNextOperation(Publisher<CoreEvent> var1, Policy var2);

    protected abstract Publisher<CoreEvent> applyPolicy(Policy var1, ReactiveProcessor var2, Publisher<CoreEvent> var3);
}

